/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location.jpa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sip.address.Address;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.mobicents.slee.services.sip.location.LocationService;
import org.mobicents.slee.services.sip.location.LocationServiceException;
import org.mobicents.slee.services.sip.location.RegistrationBinding;
import org.mobicents.slee.services.sip.location.jmx.LocationServiceManagement;
import org.mobicents.slee.services.sip.location.jpa.JPARegistrationBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPALocationService
implements LocationService {
    private static EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"mobicents-slee-examples-sipservices-location-pu");
    private static final Logger logger = Logger.getLogger(LocationService.class);

    public void init() {
        if (entityManagerFactory == null || !entityManagerFactory.isOpen()) {
            entityManagerFactory = Persistence.createEntityManagerFactory((String)"mobicents-slee-examples-sipservices-location-pu");
        }
        LocationServiceManagement.create((LocationService)this);
        logger.info((Object)"JPA Location Service started.");
    }

    public void shutdown() {
        LocationServiceManagement.destroy();
        entityManagerFactory.close();
        entityManagerFactory = null;
        logger.info((Object)"JPA Location Service shutdown.");
    }

    public RegistrationBinding addBinding(String sipAddress, Address contactAddress, String comment, long expires, long registrationDate, float qValue, String callId, long cSeq) throws LocationServiceException {
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        JPARegistrationBinding registrationBinding = new JPARegistrationBinding(sipAddress, contactAddress, comment, expires, registrationDate, qValue, callId, cSeq);
        try {
            entityManager.persist((Object)registrationBinding);
            JPARegistrationBinding jPARegistrationBinding = registrationBinding;
            return jPARegistrationBinding;
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            entityManager.close();
        }
    }

    public Map<Address, RegistrationBinding> getBindings(String sipAddress) throws LocationServiceException {
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        HashMap<Address, RegistrationBinding> resultMap = new HashMap<Address, RegistrationBinding>();
        try {
            List resultList = entityManager.createNamedQuery("selectBindingsForSipAddress").setParameter("sipAddress", (Object)sipAddress).getResultList();
            for (Object object : resultList) {
                RegistrationBinding registrationBinding = (RegistrationBinding)object;
                resultMap.put(registrationBinding.getContactAddress(), registrationBinding);
            }
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            entityManager.close();
        }
        return resultMap;
    }

    public void updateBinding(RegistrationBinding registrationBinding) throws LocationServiceException {
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        JPARegistrationBinding jPARegistrationBinding = (JPARegistrationBinding)registrationBinding;
        try {
            entityManager.createNamedQuery("updateBindingByKey").setParameter("sipAddress", (Object)jPARegistrationBinding.getKey().getSipAddress()).setParameter("contactAddress", (Object)jPARegistrationBinding.getKey().getContactAddress()).setParameter("callId", (Object)jPARegistrationBinding.getCallId()).setParameter("comment", (Object)jPARegistrationBinding.getComment()).setParameter("cSeq", (Object)jPARegistrationBinding.getCSeq()).setParameter("expires", (Object)jPARegistrationBinding.getExpires()).setParameter("registrationDate", (Object)jPARegistrationBinding.getRegistrationDate()).setParameter("qValue", (Object)Float.valueOf(jPARegistrationBinding.getQValue())).executeUpdate();
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            entityManager.close();
        }
    }

    public void removeBinding(String sipAddress, Address sipContact) throws LocationServiceException {
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        try {
            entityManager.createNamedQuery("deleteBindingsByKey").setParameter("sipAddress", (Object)sipAddress).setParameter("contactAddress", (Object)sipContact).executeUpdate();
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            entityManager.close();
        }
    }

    public Set<String> getRegisteredUsers() throws LocationServiceException {
        TransactionManager transactionManager = null;
        EntityManager entityManager = null;
        boolean startedTx = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            if (transactionManager.getTransaction() == null) {
                transactionManager.begin();
                startedTx = true;
            }
            entityManager = entityManagerFactory.createEntityManager();
            HashSet<String> resultSet = new HashSet<String>();
            List resultList = entityManager.createNamedQuery("selectAllBindings").getResultList();
            for (Object object : resultList) {
                JPARegistrationBinding registrationBinding = (JPARegistrationBinding)((Object)object);
                resultSet.add(registrationBinding.getKey().getSipAddress());
            }
            HashSet<String> hashSet = resultSet;
            return hashSet;
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            if (entityManager != null) {
                try {
                    entityManager.close();
                }
                catch (Exception f) {
                    throw new LocationServiceException(f.getLocalizedMessage());
                }
            }
            if (startedTx && transactionManager != null) {
                try {
                    transactionManager.commit();
                }
                catch (Exception f) {
                    throw new LocationServiceException(f.getLocalizedMessage());
                }
            }
        }
    }

    public Set<String> getContacts(String sipAddress) throws LocationServiceException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            transactionManager.begin();
            Set<Address> addressSet = this.getBindings(sipAddress).keySet();
            HashSet<String> resultSet = new HashSet<String>();
            for (Address address : addressSet) {
                resultSet.add(address.getURI().toString());
            }
            HashSet<String> hashSet = resultSet;
            return hashSet;
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.commit();
                }
                catch (Exception f) {
                    throw new LocationServiceException(f.getLocalizedMessage());
                }
            }
        }
    }

    public long getExpirationTime(String sipAddress, String contactAddress) throws LocationServiceException {
        TransactionManager transactionManager = null;
        EntityManager entityManager = null;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            transactionManager.begin();
            entityManager = entityManagerFactory.createEntityManager();
            Map<Address, RegistrationBinding> bindings = this.getBindings(sipAddress);
            for (Address address : bindings.keySet()) {
                if (!address.getURI().toString().equals(contactAddress)) continue;
                long l = bindings.get(address).getExpiresDelta();
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            if (entityManager != null) {
                try {
                    entityManager.close();
                }
                catch (Exception f) {
                    throw new LocationServiceException(f.getLocalizedMessage());
                }
            }
            if (transactionManager != null) {
                try {
                    transactionManager.commit();
                }
                catch (Exception f) {
                    throw new LocationServiceException(f.getLocalizedMessage());
                }
            }
        }
    }

    public int getRegisteredUserCount() throws LocationServiceException {
        return this.getRegisteredUsers().size();
    }
}

