/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location.jmx;

import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.services.sip.location.LocationService;
import org.mobicents.slee.services.sip.location.LocationServiceException;
import org.mobicents.slee.services.sip.location.jmx.LocationServiceManagementMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationServiceManagement
implements LocationServiceManagementMBean {
    private final LocationService locationService;

    private LocationServiceManagement(LocationService locationService) {
        this.locationService = locationService;
    }

    @Override
    public Set<String> getContacts(String sipAddress) throws LocationServiceException {
        return this.locationService.getContacts(sipAddress);
    }

    @Override
    public long getExpirationTime(String sipAddress, String contactAddress) throws LocationServiceException {
        return this.locationService.getExpirationTime(sipAddress, contactAddress);
    }

    @Override
    public int getRegisteredUserCount() throws LocationServiceException {
        return this.locationService.getRegisteredUserCount();
    }

    @Override
    public Set<String> getRegisteredUsers() throws LocationServiceException {
        return this.locationService.getRegisteredUsers();
    }

    public static boolean create(LocationService locationService) {
        MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
        ObjectName on = null;
        try {
            on = new ObjectName("slee:sipservice=Location");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (mbs.getObjectInstance(on) != null) {
                mbs.unregisterMBean(on);
            }
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mbs.registerMBean(new LocationServiceManagement(locationService), on);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            return false;
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            return false;
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void destroy() {
        try {
            SleeContainer.lookupFromJndi().getMBeanServer().unregisterMBean(new ObjectName("slee:sipservice=Location"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

