/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.example.sip11.b2b;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.header.CSeqHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;

public abstract class SimpleSip11B2BTestSbb
implements Sbb {
    private SbbContext sbbContext;
    private static Tracer tracer;
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private SleeSipProvider sipProvider;

    public void onInviteEvent(RequestEvent event, ActivityContextInterface aci) {
        try {
            DialogActivity incomingDialog = (DialogActivity)this.sipProvider.getNewDialog((Transaction)event.getServerTransaction());
            DialogActivity outgoingDialog = this.sipProvider.getNewDialog(incomingDialog, true);
            ActivityContextInterface outgoingDialogACI = this.sipActivityContextInterfaceFactory.getActivityContextInterface(outgoingDialog);
            ActivityContextInterface incomingDialogACI = this.sipActivityContextInterfaceFactory.getActivityContextInterface(incomingDialog);
            SbbLocalObject sbbLocalObject = this.sbbContext.getSbbLocalObject();
            incomingDialogACI.attach(sbbLocalObject);
            outgoingDialogACI.attach(sbbLocalObject);
            this.setIncomingDialog(incomingDialogACI);
            this.setOutgoingDialog(outgoingDialogACI);
            this.forwardRequest(event, outgoingDialog);
        }
        catch (Throwable e) {
            tracer.severe("Failed to process incoming INVITE.", e);
            this.replyToRequestEvent(event, 503);
        }
    }

    public void on1xxResponse(ResponseEvent event, ActivityContextInterface aci) {
        if (event.getResponse().getStatusCode() == 100) {
            return;
        }
        this.processResponse(event, aci);
    }

    public void on2xxResponse(ResponseEvent event, ActivityContextInterface aci) {
        CSeqHeader cseq = (CSeqHeader)event.getResponse().getHeader("CSeq");
        if (cseq.getMethod().equals("INVITE")) {
            try {
                Request ack = event.getDialog().createAck(cseq.getSeqNumber());
                event.getDialog().sendAck(ack);
            }
            catch (Exception e) {
                tracer.severe("Unable to ack INVITE's 200 ok from UAS", (Throwable)e);
            }
        } else if (cseq.getMethod().equals("BYE") || cseq.getMethod().equals("CANCEL")) {
            return;
        }
        this.processResponse(event, aci);
    }

    public void onBye(RequestEvent event, ActivityContextInterface aci) {
        this.replyToRequestEvent(event, 200);
        this.processMidDialogRequest(event, aci);
    }

    public void onCancel(CancelRequestEvent event, ActivityContextInterface aci) {
        if (tracer.isInfoEnabled()) {
            tracer.info("Got a CANCEL request.");
        }
        try {
            this.sipProvider.acceptCancel(event, false);
            ActivityContextInterface peerDialogACI = this.getPeerDialog(aci);
            DialogActivity peerDialog = (DialogActivity)peerDialogACI.getActivity();
            DialogState peerDialogState = peerDialog.getState();
            if (peerDialogState == null || peerDialogState == DialogState.EARLY) {
                peerDialog.sendCancel();
            } else {
                peerDialog.sendRequest(peerDialog.createRequest("BYE"));
            }
        }
        catch (Exception e) {
            tracer.severe("Failed to process cancel request", (Throwable)e);
        }
    }

    private void replyToRequestEvent(RequestEvent event, int status) {
        try {
            event.getServerTransaction().sendResponse(this.sipProvider.getMessageFactory().createResponse(status, event.getRequest()));
        }
        catch (Throwable e) {
            tracer.severe("Failed to reply to request event:\n" + event, e);
        }
    }

    private void processMidDialogRequest(RequestEvent event, ActivityContextInterface dialogACI) {
        try {
            ActivityContextInterface peerACI = this.getPeerDialog(dialogACI);
            this.forwardRequest(event, (DialogActivity)peerACI.getActivity());
        }
        catch (SipException e) {
            tracer.severe(e.getMessage(), (Throwable)e);
            this.replyToRequestEvent(event, 503);
        }
    }

    private void processResponse(ResponseEvent event, ActivityContextInterface aci) {
        try {
            ActivityContextInterface peerACI = this.getPeerDialog(aci);
            this.forwardResponse((DialogActivity)aci.getActivity(), (DialogActivity)peerACI.getActivity(), event.getClientTransaction(), event.getResponse());
        }
        catch (SipException e) {
            tracer.severe(e.getMessage(), (Throwable)e);
        }
    }

    private ActivityContextInterface getPeerDialog(ActivityContextInterface aci) throws SipException {
        ActivityContextInterface incomingDialogAci = this.getIncomingDialog();
        if (aci.equals(incomingDialogAci)) {
            return this.getOutgoingDialog();
        }
        if (aci.equals(this.getOutgoingDialog())) {
            return incomingDialogAci;
        }
        throw new SipException("could not find peer dialog");
    }

    private void forwardRequest(RequestEvent event, DialogActivity out) throws SipException {
        Request incomingRequest = event.getRequest();
        if (tracer.isInfoEnabled()) {
            tracer.info("Forwarding request " + incomingRequest.getMethod() + " to dialog " + out);
        }
        Request outgoingRequest = out.createRequest(incomingRequest);
        ClientTransaction ct = out.sendRequest(outgoingRequest);
        out.associateServerTransaction(ct, event.getServerTransaction());
    }

    private void forwardResponse(DialogActivity in, DialogActivity out, ClientTransaction ct, Response receivedResponse) throws SipException {
        ServerTransaction st = in.getAssociatedServerTransaction(ct);
        if (st == null) {
            throw new SipException("could not find associated server transaction");
        }
        if (tracer.isInfoEnabled()) {
            tracer.info("Forwarding response " + receivedResponse.getStatusCode() + " to dialog " + out);
        }
        Response outgoingResponse = out.createResponse(st, receivedResponse);
        try {
            st.sendResponse(outgoingResponse);
        }
        catch (InvalidArgumentException e) {
            tracer.severe("Failed to send response:\n" + outgoingResponse, (Throwable)e);
            throw new SipException("invalid response", (Throwable)e);
        }
    }

    public abstract void setIncomingDialog(ActivityContextInterface var1);

    public abstract ActivityContextInterface getIncomingDialog();

    public abstract void setOutgoingDialog(ActivityContextInterface var1);

    public abstract ActivityContextInterface getOutgoingDialog();

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        if (tracer == null) {
            tracer = this.sbbContext.getTracer(SimpleSip11B2BTestSbb.class.getSimpleName());
        }
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.sipProvider = (SleeSipProvider)ctx.lookup("slee/resources/jainsip/1.2/provider");
        }
        catch (NamingException e) {
            tracer.severe(e.getMessage(), (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }
}

