/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.demo;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.text.ParseException;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.mgcp.demo.events.CustomEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConferenceSbb
implements Sbb {
    public static final String JBOSS_BIND_ADDRESS = System.getProperty("jboss.bind.address", "127.0.0.1");
    public static final String ENDPOINT_NAME = "/mobicents/media/cnf/$";
    public static final int MGCP_PEER_PORT = 2427;
    public static final int MGCP_PORT = 2727;
    public static final String CONFERENCE_DEMO = "2012";
    private SbbContext sbbContext;
    private SleeSipProvider provider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SipActivityContextInterfaceFactory acif;
    private JainMgcpProvider mgcpProvider;
    private MgcpActivityContextInterfaceFactory mgcpAcif;
    private Tracer logger;

    public void onCallCreated(RequestEvent evt, ActivityContextInterface aci) {
        Request request = evt.getRequest();
        FromHeader from = (FromHeader)request.getHeader("From");
        String fromURI = from.getAddress().getURI().toString();
        ToHeader to = (ToHeader)request.getHeader("To");
        this.logger.info("Incoming call " + from + " " + to);
        ActivityContextInterface daci = null;
        try {
            Dialog dialog = this.provider.getNewDialog((Transaction)evt.getServerTransaction());
            dialog.terminateOnBye(true);
            daci = this.acif.getActivityContextInterface((DialogActivity)dialog);
            daci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (Exception e) {
            this.logger.severe("Error during dialog creation", (Throwable)e);
            this.respond(evt, 500);
            return;
        }
        HashMap<String, Integer> fromVsConnIdMap = this.getFromVsConnIdMap();
        HashMap<Integer, Object> txIdVsServerTxMap = this.getTxIdVsServerTxMap();
        EndpointIdentifier endpointID = this.getEndpointIdentifier();
        CallIdentifier callID = this.getCallIdentifier();
        if (endpointID == null) {
            this.logger.info("This is new Conference");
            endpointID = new EndpointIdentifier(ENDPOINT_NAME, JBOSS_BIND_ADDRESS + ":" + 2427);
            fromVsConnIdMap = new HashMap<String, Integer>();
            txIdVsServerTxMap = new HashMap();
            callID = this.mgcpProvider.getUniqueCallIdentifier();
            this.setCallIdentifier(callID);
        } else {
            this.logger.info("Conference has already begun at endpoint " + endpointID);
        }
        CreateConnection createConnection = new CreateConnection((Object)this, callID, endpointID, ConnectionMode.SendRecv);
        try {
            String sdp = new String(evt.getRequest().getRawContent());
            createConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp));
        }
        catch (ConflictingParameterException e) {
            this.logger.severe("Erro while setting SDP in CRCX", (Throwable)e);
        }
        int txID = this.mgcpProvider.getUniqueTransactionHandler();
        fromVsConnIdMap.put(fromURI, txID);
        txIdVsServerTxMap.put(txID, evt.getServerTransaction());
        this.setTxIdVsServerTxMap(txIdVsServerTxMap);
        this.setFromVsConnIdMap(fromVsConnIdMap);
        createConnection.setTransactionHandle(txID);
        MgcpConnectionActivity connectionActivity = null;
        try {
            connectionActivity = this.mgcpProvider.getConnectionActivity(txID, endpointID);
            ActivityContextInterface epnAci = this.mgcpAcif.getActivityContextInterface(connectionActivity);
            epnAci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (FactoryException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        catch (UnrecognizedActivityException ex) {
            ex.printStackTrace();
        }
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{createConnection});
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) {
        this.logger.info("Receive CRCX response: " + event.getTransactionHandle());
        ServerTransaction txn = null;
        HashMap fromVsConnIdMap = this.getFromVsConnIdMap();
        for (String fromUri : fromVsConnIdMap.keySet()) {
            Object obj = fromVsConnIdMap.get(fromUri);
            if (!(obj instanceof Integer)) continue;
            int txId = (Integer)obj;
            if (event.getTransactionHandle() != txId) continue;
            txn = this.getTxIdVsServerTxMap().remove(txId);
            fromVsConnIdMap.put(fromUri, event.getConnectionIdentifier());
            break;
        }
        Request request = txn.getRequest();
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.setEndpointIdentifier(event.getSpecificEndpointIdentifier());
                String sdp = event.getLocalConnectionDescriptor().toString();
                ContentTypeHeader contentType = null;
                try {
                    contentType = this.headerFactory.createContentTypeHeader("application", "sdp");
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                String localAddress = this.provider.getListeningPoints()[0].getIPAddress();
                int localPort = this.provider.getListeningPoints()[0].getPort();
                Address contactAddress = null;
                try {
                    contactAddress = this.addressFactory.createAddress("sip:" + localAddress + ":" + localPort);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                ContactHeader contact = this.headerFactory.createContactHeader(contactAddress);
                Response response = null;
                try {
                    response = this.messageFactory.createResponse(200, request, contentType, sdp.getBytes());
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                response.setHeader((Header)contact);
                try {
                    txn.sendResponse(response);
                    if (fromVsConnIdMap.size() != 1) break;
                    CustomEvent cutEvent = new CustomEvent(this.getEndpointIdentifier().getLocalEndpointName(), this.getCallIdentifier().toString());
                    this.fireConferenceInitiate(cutEvent, aci, null);
                }
                catch (InvalidArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (SipException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            default: {
                try {
                    Response response = this.messageFactory.createResponse(500, request);
                    txn.sendResponse(response);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void onCallTerminated(RequestEvent evt, ActivityContextInterface aci) {
        try {
            Request request = evt.getRequest();
            FromHeader from = (FromHeader)request.getHeader("From");
            String fromURI = from.getAddress().getURI().toString();
            ConnectionIdentifier connId = (ConnectionIdentifier)this.getFromVsConnIdMap().remove(fromURI);
            EndpointIdentifier endpointID = this.getEndpointIdentifier();
            DeleteConnection deleteConnection = new DeleteConnection((Object)this, this.getCallIdentifier(), endpointID, connId);
            deleteConnection.setTransactionHandle(this.mgcpProvider.getUniqueTransactionHandler());
            this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
            ServerTransaction tx = evt.getServerTransaction();
            Response response = this.messageFactory.createResponse(200, request);
            tx.sendResponse(response);
            if (this.getFromVsConnIdMap().size() == 0) {
                CustomEvent cutEvent = new CustomEvent(this.getEndpointIdentifier().getLocalEndpointName(), this.getCallIdentifier().toString());
                this.fireConferenceTerminate(cutEvent, this.getMgcpConnectionACI(), null);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while sending DLCX", (Throwable)e);
        }
    }

    public abstract void fireConferenceInitiate(CustomEvent var1, ActivityContextInterface var2, javax.slee.Address var3);

    public abstract void fireConferenceTerminate(CustomEvent var1, ActivityContextInterface var2, javax.slee.Address var3);

    public InitialEventSelector callIDSelect(InitialEventSelector ies) {
        Request request;
        ToHeader to;
        String destination;
        Object event = ies.getEvent();
        if (event instanceof RequestEvent && (destination = (to = (ToHeader)(request = ((RequestEvent)event).getRequest()).getHeader("To")).toString()).indexOf(CONFERENCE_DEMO) > 0) {
            ies.setCustomName(CONFERENCE_DEMO);
            return ies;
        }
        ies.setInitialEvent(false);
        return ies;
    }

    private void respond(RequestEvent evt, int cause) {
        Request request = evt.getRequest();
        ServerTransaction tx = evt.getServerTransaction();
        try {
            Response response = this.messageFactory.createResponse(cause, request);
            tx.sendResponse(response);
        }
        catch (Exception e) {
            this.logger.warning("Unexpected error: ", (Throwable)e);
        }
    }

    private ActivityContextInterface getMgcpConnectionACI() {
        ActivityContextInterface[] activities;
        for (ActivityContextInterface activity : activities = this.sbbContext.getActivities()) {
            if (!(activity.getActivity() instanceof MgcpConnectionActivity)) continue;
            return activity;
        }
        return null;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        this.logger = sbbContext.getTracer(ConferenceSbb.class.getSimpleName());
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.provider = (SleeSipProvider)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.provider.getAddressFactory();
            this.headerFactory = this.provider.getHeaderFactory();
            this.messageFactory = this.provider.getMessageFactory();
            this.acif = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.mgcpProvider = (JainMgcpProvider)ctx.lookup("slee/resources/jainmgcp/2.0/provider/demo");
            this.mgcpAcif = (MgcpActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainmgcp/2.0/acifactory/demo");
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public abstract EndpointIdentifier getEndpointIdentifier();

    public abstract void setEndpointIdentifier(EndpointIdentifier var1);

    public abstract CallIdentifier getCallIdentifier();

    public abstract void setCallIdentifier(CallIdentifier var1);

    public abstract HashMap getFromVsConnIdMap();

    public abstract void setFromVsConnIdMap(HashMap var1);

    public abstract HashMap<Integer, ServerTransaction> getTxIdVsServerTxMap();

    public abstract void setTxIdVsServerTxMap(HashMap<Integer, ServerTransaction> var1);

    public void unsetSbbContext() {
        this.sbbContext = null;
        this.logger = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
    }
}

