/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.httpservletra.example;

import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.SbbLocalObject;
import net.java.slee.resource.http.HttpServletRaActivityContextInterfaceFactory;
import net.java.slee.resource.http.HttpServletRaSbbInterface;
import net.java.slee.resource.http.HttpSessionActivity;
import net.java.slee.resource.http.events.HttpServletRequestEvent;
import org.apache.log4j.Logger;

public abstract class HttpServletRAExampleSbb
implements Sbb {
    private static Logger log = Logger.getLogger(HttpServletRAExampleSbb.class);
    private SbbContext sbbContext;
    private HttpServletRaSbbInterface httpServletRaSbbInterface;
    private HttpServletRaActivityContextInterfaceFactory httpServletRaActivityContextInterfaceFactory;

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
    }

    public void unsetSbbContext() {
    }

    public void onPost(HttpServletRequestEvent event, ActivityContextInterface aci) {
        SbbLocalObject sbbLocalObject = this.sbbContext.getSbbLocalObject();
        aci.detach(sbbLocalObject);
        try {
            HttpServletResponse response = event.getResponse();
            PrintWriter w = response.getWriter();
            w.print("onPost OK! Served by SBB = " + this.getSbbId());
            w.flush();
            response.flushBuffer();
            log.info((Object)"HttpServletRAExampleSbb: POST Request received and OK! response sent.");
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void onGet(HttpServletRequestEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        HttpServletResponse response = event.getResponse();
        PrintWriter w = null;
        try {
            w = response.getWriter();
            w.print("onGet OK! Served by SBB = " + this.getSbbId());
            w.flush();
            response.flushBuffer();
            log.info((Object)"HttpServletRAExampleSbb: GET Request received and OK! response sent.");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void onPut(HttpServletRequestEvent event, ActivityContextInterface aci) {
        SbbLocalObject sbbLocalObject = this.sbbContext.getSbbLocalObject();
        aci.detach(sbbLocalObject);
        try {
            if (this.httpServletRaSbbInterface == null) {
                Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
                this.httpServletRaSbbInterface = (HttpServletRaSbbInterface)myEnv.lookup("slee/resources/mobicents/httpservlet/sbbrainterface");
                this.httpServletRaActivityContextInterfaceFactory = (HttpServletRaActivityContextInterfaceFactory)myEnv.lookup("slee/resources/mobicents/httpservlet/acifactory");
            }
            HttpSession httpSession = event.getRequest().getSession();
            HttpSessionActivity httpSessionActivity = this.httpServletRaSbbInterface.getHttpSessionActivity(httpSession);
            ActivityContextInterface httpSessionActivityContextInterface = this.httpServletRaActivityContextInterfaceFactory.getActivityContextInterface(httpSessionActivity);
            httpSessionActivityContextInterface.attach(sbbLocalObject);
            HttpServletResponse response = event.getResponse();
            PrintWriter w = response.getWriter();
            w.print("onPut OK! Served by SBB = " + this.getSbbId());
            w.flush();
            response.flushBuffer();
            log.info((Object)"HttpServletRAExampleSbb: PUT Request received and OK! response sent.");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void onDelete(HttpServletRequestEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        HttpServletResponse response = event.getResponse();
        PrintWriter w = null;
        try {
            w = response.getWriter();
            w.print("onDelete OK! Served by SBB = " + this.getSbbId());
            w.flush();
            response.flushBuffer();
            log.info((Object)"HttpServletRAExampleSbb: DELETE Request received and OK! response sent.");
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void onOptions(HttpServletRequestEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        HttpServletResponse response = event.getResponse();
        PrintWriter w = null;
        try {
            w = response.getWriter();
            w.print("onOptions OK! Served by SBB = " + this.getSbbId());
            w.flush();
            response.flushBuffer();
            log.info((Object)"HttpServletRAExampleSbb: OPTIONS Request received and OK! response sent.");
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void onTrace(HttpServletRequestEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        HttpServletResponse response = event.getResponse();
        PrintWriter w = null;
        try {
            w = response.getWriter();
            w.print("onTrace OK! Served by SBB = " + this.getSbbId());
            w.flush();
            response.flushBuffer();
            log.info((Object)"HttpServletRAExampleSbb: TRACE Request received and OK! response sent.");
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        log.info((Object)("Got an activity end for activity " + aci.getActivity()));
    }

    private final String getSbbId() {
        SbbID sbbId = this.sbbContext.getSbb();
        return sbbId.toString();
    }
}

