/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.hibernate.validator.Email;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;
import org.jboss.seam.annotations.Name;
import org.mobicents.examples.convergeddemo.seam.model.User;

@Entity
@Name(value="customer")
@DiscriminatorValue(value="customer")
public class Customer
extends User
implements Serializable {
    private static final long serialVersionUID = 5699525147178760355L;
    public static String[] cctypes = new String[]{"MasterCard", "Visa", "Discover", "Amex", "Dell Preferred"};
    String address1;
    String address2;
    String city;
    String state;
    String zip;
    String email;
    String phone;
    Integer creditCardType = 1;
    String creditCard = "000-0000-0000";
    int ccMonth = 1;
    int ccYear = 2005;

    @Column(name="ADDRESS1", length=50)
    @NotNull
    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    @Column(name="ADDRESS2", length=50)
    @NotNull
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    @Column(name="CITY", length=50)
    @NotNull
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(name="STATE", length=2)
    @NotNull
    @Length(min=2, max=2)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="ZIP", length=10)
    @Length(min=5, max=10)
    @Pattern(regex="[0-9]{5}(-[0-9]{4})?", message="not a valid zipcode")
    @NotNull
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @Column(name="EMAIL", length=50)
    @Email
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="PHONE", length=50)
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Column(name="CREDITCARDTYPE")
    public Integer getCreditCardType() {
        return this.creditCardType;
    }

    public void setCreditCardType(Integer type) {
        this.creditCardType = type;
    }

    @Transient
    public String getCreditCardTypeString() {
        if (this.creditCardType < 1 || this.creditCardType > cctypes.length) {
            return "";
        }
        return cctypes[this.creditCardType - 1];
    }

    @Column(name="CC_NUM", length=50)
    public String getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(String creditCard) {
        this.creditCard = creditCard;
    }

    @Column(name="CC_MONTH", length=50)
    public int getCreditCardMonth() {
        return this.ccMonth;
    }

    public void setCreditCardMonth(int ccMonth) {
        this.ccMonth = ccMonth;
    }

    @Column(name="CC_YEAR", length=50)
    public int getCreditCardYear() {
        return this.ccYear;
    }

    public void setCreditCardYear(int ccYear) {
        this.ccYear = ccYear;
    }

    @Transient
    public String getCreditCardExpiration() {
        return "" + this.ccMonth + "/" + this.ccYear;
    }

    public String toString() {
        return "Customer#" + this.getId() + "(" + this.userName + ")";
    }
}

