/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.jboss.seam.annotations.Name;
import org.mobicents.examples.convergeddemo.seam.action.StoreManager;
import org.mobicents.examples.convergeddemo.seam.model.Order;

@Stateless
@Name(value="stats")
public class StoreManagerBean
implements StoreManager,
Serializable {
    private static final long serialVersionUID = 7011610947757223263L;
    @PersistenceContext
    EntityManager em;

    public long getNumberOrders() {
        return (Long)this.em.createQuery("select count(o) from Order o where o.status != :status").setParameter("status", (Object)Order.Status.CANCELLED).getSingleResult();
    }

    public BigDecimal getTotalSales() {
        try {
            BigDecimal totalSales = (BigDecimal)this.em.createQuery("select sum(o.totalAmount) from Order o where o.status != :status").setParameter("status", (Object)Order.Status.CANCELLED).getSingleResult();
            return totalSales == null ? BigDecimal.ZERO : totalSales;
        }
        catch (NoResultException e) {
            return BigDecimal.ZERO;
        }
    }

    public long getUnitsSold() {
        try {
            return (Long)this.em.createQuery("select sum(i.sales) from Inventory i").getSingleResult();
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public long getTotalInventory() {
        try {
            return (Long)this.em.createQuery("select sum(i.quantity) from Inventory i").getSingleResult();
        }
        catch (NoResultException e) {
            return 0L;
        }
    }
}

