/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.io.Serializable;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.bpm.ResumeProcess;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jbpm.graph.exe.ProcessInstance;
import org.mobicents.examples.convergeddemo.seam.action.ShowOrders;
import org.mobicents.examples.convergeddemo.seam.model.Customer;
import org.mobicents.examples.convergeddemo.seam.model.Order;

@Stateful
@Name(value="showorders")
public class ShowOrdersAction
implements ShowOrders,
Serializable {
    private static final long serialVersionUID = -5377038496721657104L;
    @In(value="currentUser", required=false)
    Customer customer;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    EntityManager em;
    @DataModel
    List<Order> orders;
    @DataModelSelection
    @Out(value="myorder", required=false, scope=ScopeType.CONVERSATION)
    Order order;
    @In(required=false)
    ProcessInstance processInstance;

    @Begin
    @Factory(value="orders")
    public String findOrders() {
        this.orders = this.em.createQuery("select o from Order o where o.customer = :customer").setParameter("customer", (Object)this.customer).getResultList();
        this.order = null;
        return "showorders";
    }

    @ResumeProcess(definition="OrderManagement", processKey="#{orders.rowData.orderId}")
    public String cancelOrder() {
        this.em.refresh((Object)this.order);
        if (this.order.getStatus() != Order.Status.OPEN) {
            return null;
        }
        this.order.setStatus(Order.Status.CANCELLED);
        this.processInstance.signal("cancel");
        return this.findOrders();
    }

    public String detailOrder() {
        this.em.refresh((Object)this.order);
        return "showorders";
    }

    @End
    public String reset() {
        return null;
    }

    @Remove
    public void destroy() {
    }
}

