/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.mobicents.examples.convergeddemo.seam.action.ShoppingCart;
import org.mobicents.examples.convergeddemo.seam.model.Order;
import org.mobicents.examples.convergeddemo.seam.model.OrderLine;
import org.mobicents.examples.convergeddemo.seam.model.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful
@Name(value="cart")
@Scope(value=ScopeType.SESSION)
public class ShoppingCartBean
implements ShoppingCart,
Serializable {
    static final long serialVersionUID = 8722576722482084467L;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    EntityManager em;
    Order cartOrder = new Order();
    Map<Product, Boolean> cartSelection = new HashMap<Product, Boolean>();

    @Override
    public List<OrderLine> getCart() {
        return this.cartOrder.getOrderLines();
    }

    @Override
    public boolean getIsEmpty() {
        return this.cartOrder.isEmpty();
    }

    @Override
    public void addProduct(Product product, int quantity) {
        this.cartOrder.addProduct(product, quantity);
        this.cartOrder.calculateTotals();
    }

    @Override
    public Map getCartSelection() {
        return this.cartSelection;
    }

    @Override
    public BigDecimal getSubtotal() {
        return this.cartOrder.getNetAmount();
    }

    @Override
    public BigDecimal getTax() {
        return this.cartOrder.getTax();
    }

    @Override
    public BigDecimal getTotal() {
        return this.cartOrder.getTotalAmount();
    }

    @Override
    public void updateCart() {
        ArrayList<OrderLine> newLines = new ArrayList<OrderLine>();
        for (OrderLine line : this.cartOrder.getOrderLines()) {
            Boolean selected;
            if (line.getQuantity() <= 0 || (selected = this.cartSelection.get(line)) != null && selected.booleanValue()) continue;
            newLines.add(line);
        }
        this.cartOrder.setOrderLines(newLines);
        this.cartOrder.calculateTotals();
        this.cartSelection = new HashMap<Product, Boolean>();
    }

    @Override
    public void resetCart() {
        this.cartOrder = new Order();
    }

    @Override
    @Remove
    public void destroy() {
    }
}

