/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.util.Date;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.FetchMode;
import org.hibernate.search.FullTextSession;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.mobicents.examples.convergeddemo.seam.action.Indexer;
import org.mobicents.examples.convergeddemo.seam.model.Actor;
import org.mobicents.examples.convergeddemo.seam.model.Category;
import org.mobicents.examples.convergeddemo.seam.model.Product;

@Name(value="indexer")
@Stateful
@Scope(value=ScopeType.APPLICATION)
@Startup
public class IndexerAction
implements Indexer {
    private Date lastIndexingTime;
    @PersistenceContext
    private EntityManager em;

    public Date getLastIndexingTime() {
        return this.lastIndexingTime;
    }

    @Create
    public void index() {
        this.indexAllClasses(Actor.class, Category.class);
        this.indexProducts();
        this.lastIndexingTime = new Date();
    }

    private void indexProducts() {
        FullTextSession fullTextSession = this.getFullTextSession();
        List results = fullTextSession.createCriteria(Product.class).setFetchMode("actors", FetchMode.JOIN).setFetchMode("categories", FetchMode.JOIN).list();
        for (Object obj : results) {
            fullTextSession.index(obj);
        }
    }

    private FullTextSession getFullTextSession() {
        return (FullTextSession)this.em.getDelegate();
    }

    private void indexAllClasses(Class ... entityTypes) {
        FullTextSession fullTextSession = this.getFullTextSession();
        for (Class entityType : entityTypes) {
            for (Object obj : fullTextSession.createCriteria(entityType).list()) {
                fullTextSession.index(obj);
            }
        }
    }

    @Remove
    @Destroy
    public void stop() {
    }
}

