/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.annotations.web.RequestParameter;
import org.mobicents.examples.convergeddemo.seam.action.FullTextSearch;
import org.mobicents.examples.convergeddemo.seam.action.ShoppingCart;
import org.mobicents.examples.convergeddemo.seam.model.Product;

@Stateful
@Name(value="search")
public class FullTextSearchAction
implements FullTextSearch,
Serializable {
    static final long serialVersionUID = -6536629890251170098L;
    @In(create=true)
    ShoppingCart cart;
    @PersistenceContext
    EntityManager em;
    @RequestParameter
    Long id;
    int pageSize = 15;
    int currentPage = 0;
    boolean hasMore = false;
    int numberOfResults;
    String searchQuery;
    @DataModel
    List<Product> searchResults;
    @DataModelSelection
    Product selectedProduct;
    @Out(required=false)
    Product dvd;
    @Out(scope=ScopeType.CONVERSATION, required=false)
    Map<Product, Boolean> searchSelections;

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    @Begin(join=true)
    public String doSearch() {
        this.currentPage = 0;
        this.updateResults();
        return "browse";
    }

    public void nextPage() {
        if (!this.isLastPage()) {
            ++this.currentPage;
            this.updateResults();
        }
    }

    public void prevPage() {
        if (!this.isFirstPage()) {
            --this.currentPage;
            this.updateResults();
        }
    }

    @Begin(join=true)
    public void selectFromRequest() {
        if (this.id != null) {
            this.dvd = (Product)this.em.find(Product.class, (Object)this.id);
        } else if (this.selectedProduct != null) {
            this.dvd = this.selectedProduct;
        }
    }

    public boolean isLastPage() {
        return this.searchResults != null && !this.hasMore;
    }

    public boolean isFirstPage() {
        return this.searchResults != null && this.currentPage == 0;
    }

    private void updateResults() {
        FullTextQuery query;
        try {
            query = this.searchQuery(this.searchQuery);
        }
        catch (ParseException pe) {
            return;
        }
        List items = query.setMaxResults(this.pageSize + 1).setFirstResult(this.pageSize * this.currentPage).getResultList();
        this.numberOfResults = query.getResultSize();
        if (items.size() > this.pageSize) {
            this.searchResults = new ArrayList<Product>(items.subList(0, this.pageSize));
            this.hasMore = true;
        } else {
            this.searchResults = items;
            this.hasMore = false;
        }
        this.searchSelections = new HashMap<Product, Boolean>();
    }

    private FullTextQuery searchQuery(String searchQuery) throws ParseException {
        HashMap<String, Float> boostPerField = new HashMap<String, Float>();
        boostPerField.put("title", Float.valueOf(4.0f));
        boostPerField.put("description", Float.valueOf(2.0f));
        boostPerField.put("actors.name", Float.valueOf(2.0f));
        boostPerField.put("categories.name", Float.valueOf(0.5f));
        String[] productFields = new String[]{"title", "description", "actors.name", "categories.name"};
        MultiFieldQueryParser parser = new MultiFieldQueryParser(productFields, (Analyzer)new StandardAnalyzer(), boostPerField);
        parser.setAllowLeadingWildcard(true);
        Query luceneQuery = parser.parse(searchQuery);
        return ((FullTextEntityManager)this.em).createFullTextQuery(luceneQuery, new Class[]{Product.class});
    }

    public void addToCart() {
        this.cart.addProduct(this.dvd, 1);
    }

    public void addAllToCart() {
        for (Product item : this.searchResults) {
            Boolean selected = this.searchSelections.get(item);
            if (selected == null || !selected.booleanValue()) continue;
            this.searchSelections.put(item, false);
            this.cart.addProduct(item, 1);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @End
    public void reset() {
    }

    @Destroy
    @Remove
    public void destroy() {
    }
}

