/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.user;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import javax.slee.nullactivity.NullActivity;
import org.apache.log4j.Logger;
import org.mobicents.examples.convergeddemo.seam.pojo.Order;
import org.mobicents.media.server.impl.common.events.EventCause;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResource;
import org.mobicents.mscontrol.MsSignalDetector;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;
import org.mobicents.slee.resource.persistence.ratype.PersistenceResourceAdaptorSbbInterface;
import org.mobicents.slee.resource.tts.ratype.TTSSession;
import org.mobicents.slee.service.callcontrol.CallControlSbbLocalObject;
import org.mobicents.slee.service.common.CommonSbb;
import org.mobicents.slee.service.events.CustomEvent;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.SessionAssociation;

public abstract class UserSbb
extends CommonSbb {
    public static final String ANNOUNCEMENT_ENDPOINT = "media/trunk/Announcement/$";
    private Logger logger = Logger.getLogger(UserSbb.class);
    private PersistenceResourceAdaptorSbbInterface persistenceResourceAdaptorSbbInterface = null;
    private MsProvider msProvider;
    private MediaRaActivityContextInterfaceFactory mediaAcif;
    String audioFilePath = null;
    String callerSip = null;
    private final String orderConfirmed = "audio/UserOrderConfirmed.wav";
    private final String orderCancelled = "audio/UserOrderCancelled.wav";
    private final String orderReConfirm = "audio/UserReConfirm.wav";

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.audioFilePath = System.getProperty("jboss.server.data.dir");
            this.callerSip = (String)myEnv.lookup("callerSip");
            this.persistenceResourceAdaptorSbbInterface = (PersistenceResourceAdaptorSbbInterface)myEnv.lookup("slee/resources/pra/0.1/provider");
            this.msProvider = (MsProvider)myEnv.lookup("slee/resources/media/1.0/provider");
            this.mediaAcif = (MediaRaActivityContextInterfaceFactory)myEnv.lookup("slee/resources/media/1.0/acifactory");
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }

    public abstract void fireOrderCancelled(CustomEvent var1, ActivityContextInterface var2, javax.slee.Address var3);

    public void onOrderPlaced(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info((Object)("UserSbb: " + (Object)((Object)this) + ": received an ORDER_PLACED event. OrderId = " + event.getOrderId() + ". ammount = " + event.getAmmount() + ". Customer Name = " + event.getCustomerName()));
        this.setCustomEvent(event);
        this.audioFilePath = this.audioFilePath + "/" + event.getUserName() + ".wav";
        this.setAudioFile(this.audioFilePath);
        TTSSession ttsSession = this.getTTSProvider().getNewTTSSession(this.audioFilePath, "kevin");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome ");
        stringBuffer.append(event.getCustomerName());
        stringBuffer.append(". You have placed an order of $");
        stringBuffer.append(event.getAmmount());
        stringBuffer.append(". Press 1 to confirm and 2 to decline.");
        ttsSession.textToAudioFile(stringBuffer.toString());
        try {
            Address callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerAddress.setDisplayName(this.callerSip);
            Address calleeAddress = this.getSipUtils().convertURIToAddress(event.getCustomerPhone());
            Request request = this.getSipUtils().buildInvite(callerAddress, calleeAddress, null, 1);
            ClientTransaction ct = this.getSipProvider().getNewClientTransaction(request);
            Header h = ct.getRequest().getHeader("Call-ID");
            String calleeCallId = ((CallIdHeader)h).getCallId();
            SessionAssociation sa = new SessionAssociation("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState");
            Session calleeSession = new Session(calleeCallId);
            calleeSession.setSipAddress(calleeAddress);
            calleeSession.setToBeCancelledClientTransaction(ct);
            Dialog dialog = ct.getDialog();
            if (dialog != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Obtained dialog from ClientTransaction : automatic dialog support on");
            }
            if (dialog == null) {
                try {
                    dialog = this.getSipProvider().getNewDialog((Transaction)ct);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Obtained dialog for INVITE request to callee with getNewDialog");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error getting dialog", (Throwable)e);
                }
            }
            ActivityContextInterface sipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(dialog);
            ActivityContextInterface clientSipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(ct);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Obtained dialog in onThirdPCCTriggerEvent : callId = " + dialog.getCallId().getCallId()));
            }
            dialog.terminateOnBye(true);
            calleeSession.setDialog(dialog);
            sa.setCalleeSession(calleeSession);
            Session callerSession = new Session();
            callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerSession.setSipAddress(callerAddress);
            callerSession.setToBeCancelledClientTransaction(null);
            sa.setCallerSession(callerSession);
            this.getCacheUtility().put(calleeCallId, (Object)sa);
            ChildRelation relation = this.getCallControlSbbChild();
            CallControlSbbLocalObject child = (CallControlSbbLocalObject)relation.create();
            this.setChildSbbLocalObject(child);
            child.setParent(this.getSbbContext().getSbbLocalObject());
            child.setCustomEvent(event);
            sipACI.attach((SbbLocalObject)child);
            clientSipACI.attach((SbbLocalObject)child);
            sipACI.attach(this.getSbbContext().getSbbLocalObject());
            ct.sendRequest();
        }
        catch (ParseException parExc) {
            this.logger.error((Object)"Parse Exception while parsing the callerAddess", (Throwable)parExc);
        }
        catch (InvalidArgumentException invalidArgExcep) {
            this.logger.error((Object)"InvalidArgumentException while building Invite Request", (Throwable)invalidArgExcep);
        }
        catch (TransactionUnavailableException tranUnavExce) {
            this.logger.error((Object)"TransactionUnavailableException when trying to getNewClientTransaction", (Throwable)tranUnavExce);
        }
        catch (UnrecognizedActivityException e) {
            this.logger.error((Object)"UnrecognizedActivityException when trying to getActivityContextInterface", (Throwable)e);
        }
        catch (CreateException creaExce) {
            this.logger.error((Object)"CreateException while trying to create Child", (Throwable)creaExce);
        }
        catch (SipException sipExec) {
            this.logger.error((Object)"SipException while trying to send INVITE Request", (Throwable)sipExec);
        }
    }

    public void onLinkReleased(MsLinkEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)"-----onLinkReleased-----");
        if (this.getSendBye()) {
            this.getChildSbbLocalObject().sendBye();
        }
    }

    public void onAnnouncementComplete(MsNotifyEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)"Announcement complete: ");
        if (this.getSendBye()) {
            MsLink link = this.getLink();
            link.release();
        }
    }

    public void onDtmf(MsNotifyEvent evt, ActivityContextInterface aci) {
        EventCause eventCause = evt.getCause();
        this.logger.info((Object)("org.mobicents.slee.media.dtmf.DTMF " + eventCause));
        this.initDtmfDetector(this.getConnection(), this.getEndpointName());
    }

    public void onInfoEvent(RequestEvent request, ActivityContextInterface aci) {
        this.logger.info((Object)"javax.sip.dialog.Request.INFO received");
        try {
            this.getSipUtils().sendStatefulOk(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties p = new Properties();
        try {
            p.load(new ByteArrayInputStream(request.getRequest().getRawContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String dtmf = p.getProperty("Signal");
        this.logger.debug((Object)("The Dtmf is " + dtmf));
        int cause = Integer.parseInt(dtmf);
        this.logger.debug((Object)("onDtmf " + cause));
        this.handleDtmf(cause);
    }

    public void handleDtmf(int cause) {
        EntityManager mgr = null;
        Order order = null;
        boolean successful = false;
        switch (cause) {
            case 1: {
                this.setAudioFile(((Object)((Object)this)).getClass().getResource("audio/UserOrderConfirmed.wav").toString());
                mgr = this.persistenceResourceAdaptorSbbInterface.createEntityManager(new HashMap(), "custom-pu");
                order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
                order.setStatus(Order.Status.OPEN);
                mgr.flush();
                mgr.close();
                successful = true;
                break;
            }
            case 2: {
                this.setAudioFile(((Object)((Object)this)).getClass().getResource("audio/UserOrderCancelled.wav").toString());
                mgr = this.persistenceResourceAdaptorSbbInterface.createEntityManager(new HashMap(), "custom-pu");
                order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
                order.setStatus(Order.Status.CANCELLED);
                mgr.flush();
                mgr.close();
                successful = true;
                try {
                    NullActivity nullActivity = this.getNullActivityFactory().createNullActivity();
                    ActivityContextInterface nullActivityContextInterface = this.getNullACIFactory().getActivityContextInterface(nullActivity);
                    this.fireOrderCancelled((CustomEvent)this.getCustomEvent().clone(), nullActivityContextInterface, null);
                }
                catch (UnrecognizedActivityException unreActExc) {
                    unreActExc.printStackTrace();
                }
                break;
            }
            default: {
                this.setAudioFile(((Object)((Object)this)).getClass().getResource("audio/UserReConfirm.wav").toString());
            }
        }
        this.setSendBye(successful);
        MsSignalGenerator generator = this.msProvider.getSignalGenerator(this.getAnnouncementEndpointName());
        try {
            ActivityContextInterface generatorActivity = this.mediaAcif.getActivityContextInterface((MsResource)generator);
            generatorActivity.attach(this.getSbbContext().getSbbLocalObject());
            generator.apply(EventID.PLAY, new String[]{this.getAudioFile()});
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }

    public void onLinkCreated(MsLinkEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)"--------onLinkCreated------------");
        MsLink link = evt.getSource();
        String announcementEndpoint = link.getEndpoints()[1];
        String endpointName = null;
        if (this.getEndpointName() == null) {
            this.setEndpointName(link.getEndpoints()[0]);
        }
        if (this.getAnnouncementEndpointName() == null) {
            this.setAnnouncementEndpointName(announcementEndpoint);
        }
        endpointName = this.getEndpointName();
        this.logger.info((Object)("endpoint name: " + endpointName));
        this.logger.info((Object)("Announcement endpoint: " + announcementEndpoint));
        MsSignalGenerator generator = this.msProvider.getSignalGenerator(announcementEndpoint);
        try {
            ActivityContextInterface generatorActivity = this.mediaAcif.getActivityContextInterface((MsResource)generator);
            generatorActivity.attach(this.getSbbContext().getSbbLocalObject());
            String announcementFile = "file:" + this.getAudioFile();
            generator.apply(EventID.PLAY, new String[]{announcementFile});
            this.initDtmfDetector(this.getConnection(), endpointName);
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }

    public MsLink getLink() {
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsLink)) continue;
            return (MsLink)activities[i].getActivity();
        }
        return null;
    }

    private MsConnection getConnection() {
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsConnection)) continue;
            return (MsConnection)activities[i].getActivity();
        }
        return null;
    }

    private void initDtmfDetector(MsConnection connection, String endpointName) {
        MsSignalDetector dtmfDetector = this.msProvider.getSignalDetector(endpointName);
        try {
            ActivityContextInterface dtmfAci = this.mediaAcif.getActivityContextInterface((MsResource)dtmfDetector);
            dtmfAci.attach(this.getSbbContext().getSbbLocalObject());
            dtmfDetector.receive(EventID.DTMF, connection, new String[0]);
        }
        catch (UnrecognizedActivityException e) {
            // empty catch block
        }
    }

    public abstract ChildRelation getCallControlSbbChild();

    public abstract void setCustomEvent(CustomEvent var1);

    public abstract CustomEvent getCustomEvent();

    public abstract void setSendBye(boolean var1);

    public abstract boolean getSendBye();

    public abstract void setEndpointName(String var1);

    public abstract String getEndpointName();

    public abstract void setAnnouncementEndpointName(String var1);

    public abstract String getAnnouncementEndpointName();

    public abstract void setAudioFile(String var1);

    public abstract String getAudioFile();

    public abstract void setChildSbbLocalObject(CallControlSbbLocalObject var1);

    public abstract CallControlSbbLocalObject getChildSbbLocalObject();
}

