/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.demo;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.mobicents.slee.resource.sip.SipResourceAdaptorSbbInterface;

public abstract class CallSbb
implements Sbb {
    private static int CALL_ID_GEN = 1;
    private static int GEN = 1;
    public static final String ENDPOINT_NAME = "media/test/Loopback/1";
    public static final String HELLO_WORLD = "http://localhost/mgcpdemo/audio/helloworld.wav";
    private SbbContext sbbContext;
    private SipResourceAdaptorSbbInterface fp;
    private SipProvider sipProvider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SipActivityContextInterfaceFactory acif;
    private JainMgcpProvider mgcpProvider;
    private MgcpActivityContextInterfaceFactory mgcpAcif;
    private Logger logger = Logger.getLogger(CallSbb.class);

    public void onCallCreated(RequestEvent evt, ActivityContextInterface aci) {
        Request request = evt.getRequest();
        this.respond(evt, 100);
        FromHeader from = (FromHeader)request.getHeader("From");
        ToHeader to = (ToHeader)request.getHeader("To");
        this.logger.info((Object)("Incoming call " + from + " " + to));
        ActivityContextInterface daci = null;
        try {
            Dialog dialog = this.sipProvider.getNewDialog((Transaction)evt.getServerTransaction());
            dialog.terminateOnBye(true);
            daci = this.acif.getActivityContextInterface(dialog);
            daci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (Exception e) {
            this.logger.error((Object)"Error during dialog creation", (Throwable)e);
            this.respond(evt, 500);
            return;
        }
        CallIdentifier callID = new CallIdentifier(Integer.toHexString(CALL_ID_GEN++));
        EndpointIdentifier endpointID = new EndpointIdentifier(ENDPOINT_NAME, "localhost:2727");
        CreateConnection createConnection = new CreateConnection((Object)this, callID, endpointID, ConnectionMode.SendRecv);
        try {
            String sdp = new String(evt.getRequest().getRawContent());
            createConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp));
        }
        catch (ConflictingParameterException e) {
            // empty catch block
        }
        int txID = GEN++;
        createConnection.setTransactionHandle(txID);
        MgcpConnectionActivity connectionActivity = null;
        try {
            connectionActivity = this.mgcpProvider.getConnectionActivity(txID);
            ActivityContextInterface epnAci = this.mgcpAcif.getActivityContextInterface(connectionActivity);
            epnAci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (FactoryException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        catch (UnrecognizedActivityException ex) {
            ex.printStackTrace();
        }
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{createConnection});
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) throws ParseException {
        this.logger.info((Object)("Receive CRCX response: " + event.getTransactionHandle()));
        ServerTransaction txn = this.getServerTransaction();
        Request request = txn.getRequest();
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.setConnectionIdentifier(event.getConnectionIdentifier().toString());
                String sdp = event.getLocalConnectionDescriptor().toString();
                ContentTypeHeader contentType = null;
                try {
                    contentType = this.headerFactory.createContentTypeHeader("application", "sdp");
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                String localAddress = this.sipProvider.getListeningPoints()[0].getIPAddress();
                int localPort = this.sipProvider.getListeningPoints()[0].getPort();
                Address contactAddress = null;
                try {
                    contactAddress = this.addressFactory.createAddress("sip:" + localAddress + ":" + localPort);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                ContactHeader contact = this.headerFactory.createContactHeader(contactAddress);
                Response response = null;
                try {
                    response = this.messageFactory.createResponse(180, request, contentType, sdp.getBytes());
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                response.setHeader((Header)contact);
                try {
                    txn.sendResponse(response);
                }
                catch (InvalidArgumentException ex) {
                }
                catch (SipException ex) {}
                break;
            }
            default: {
                try {
                    Response response = this.messageFactory.createResponse(500, request);
                    txn.sendResponse(response);
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void onCallTerminated(RequestEvent evt, ActivityContextInterface aci) {
        EndpointIdentifier endpointID = new EndpointIdentifier(ENDPOINT_NAME, "localhost:2727");
        DeleteConnection deleteConnection = new DeleteConnection((Object)this, endpointID);
        deleteConnection.setConnectionIdentifier(new ConnectionIdentifier(this.getConnectionIdentifier()));
        int txID = GEN++;
        deleteConnection.setTransactionHandle(txID);
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
    }

    private void respond(RequestEvent evt, int cause) {
        Request request = evt.getRequest();
        ServerTransaction tx = evt.getServerTransaction();
        try {
            Response response = this.messageFactory.createResponse(cause, request);
            tx.sendResponse(response);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unexpected error: ", (Throwable)e);
        }
    }

    private ServerTransaction getServerTransaction() {
        ActivityContextInterface[] activities;
        for (ActivityContextInterface activity : activities = this.sbbContext.getActivities()) {
            if (!(activity.getActivity() instanceof ServerTransaction)) continue;
            return (ServerTransaction)activity.getActivity();
        }
        return null;
    }

    private Dialog getDialog() {
        ActivityContextInterface[] activities;
        for (ActivityContextInterface activity : activities = this.sbbContext.getActivities()) {
            if (!(activity.getActivity() instanceof Dialog)) continue;
            return (Dialog)activity.getActivity();
        }
        return null;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.fp = (SipResourceAdaptorSbbInterface)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.sipProvider = this.fp.getSipProvider();
            this.addressFactory = this.fp.getAddressFactory();
            this.headerFactory = this.fp.getHeaderFactory();
            this.messageFactory = this.fp.getMessageFactory();
            this.acif = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.mgcpProvider = (JainMgcpProvider)ctx.lookup("slee/resources/jainmgcp/2.0/provider");
            this.mgcpAcif = (MgcpActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainmgcp/2.0/acifactory");
        }
        catch (Exception ne) {
            this.logger.error((Object)"Could not set SBB context:", (Throwable)ne);
        }
    }

    public abstract String getConnectionIdentifier();

    public abstract void setConnectionIdentifier(String var1);

    public void unsetSbbContext() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
    }
}

