/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.callcontrol.blocking;

import java.text.ParseException;
import java.util.ArrayList;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.profile.ProfileID;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import org.mobicents.slee.examples.callcontrol.blocking.CallBlockingSbbActivityContextInterface;
import org.mobicents.slee.examples.callcontrol.common.SubscriptionProfileSbb;
import org.mobicents.slee.examples.callcontrol.profile.CallControlProfileCMP;

public abstract class CallBlockingSbb
extends SubscriptionProfileSbb
implements Sbb {
    public void onInvite(RequestEvent event, CallBlockingSbbActivityContextInterface localAci) {
        Request request = event.getRequest();
        try {
            localAci.detach(this.getSbbLocalObject());
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            URI fromURI = fromHeader.getAddress().getURI();
            URI toURI = toHeader.getAddress().getURI();
            ((SipURI)fromURI).removePort();
            ((SipURI)toURI).removePort();
            ArrayList targets = this.getBlockedArrayList(toURI.toString());
            if (targets != null) {
                for (int i = 0; i < targets.size(); ++i) {
                    if (!targets.get(i).toString().equalsIgnoreCase(fromURI.toString())) continue;
                    log.info((Object)("########## BLOCKING ADDRESS: " + targets.get(i)));
                    log.info((Object)("########## BLOCKING FOR URI: " + toURI));
                    localAci.setFilteredByMe(true);
                    ServerTransaction stBlocking = (ServerTransaction)localAci.getActivity();
                    Response blockingResponse = this.getMessageFactory().createResponse(403, request);
                    stBlocking.sendResponse(blockingResponse);
                }
            }
        }
        catch (TransactionRequiredLocalException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SLEEException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SipException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private ArrayList getBlockedArrayList(String sipAddress) {
        Address[] addresses;
        ArrayList<SipURI> uris = null;
        CallControlProfileCMP profile = this.lookup(new Address(AddressPlan.SIP, sipAddress));
        if (profile != null && (addresses = profile.getBlockedAddresses()) != null) {
            uris = new ArrayList<SipURI>(addresses.length);
            for (int i = 0; i < addresses.length; ++i) {
                String address = addresses[i].getAddressString();
                try {
                    SipURI uri = (SipURI)this.getAddressFactory().createURI(address);
                    uris.add(uri);
                    continue;
                }
                catch (ParseException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return uris;
    }

    public abstract CallControlProfileCMP getCallControlProfileCMP(ProfileID var1) throws UnrecognizedProfileNameException, UnrecognizedProfileTableNameException;

    public abstract CallBlockingSbbActivityContextInterface asSbbActivityContextInterface(ActivityContextInterface var1);
}

