/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jdiameter.api;

/**
 * This interface allows to control the stack at overload moment
 * 
 * @author erick.svenson@yahoo.com
 * @version 1.5.1 Final
 */
public interface OverloadManager {

  /**
   * Notify stack that parent application has overload
   * @param id Overloaded application id (null for stack owner)
   * @param type type of overload (CPU, Memory..)
   * @param value value of overload
   */
  void parentAppOverloadDetected(ApplicationId id, int type, double value);

  /**
   * Notifies stack that parent application has overload cased
   * @param id Overloaded application id (null for stack owner)
   * @param type type of overload (CPU, Memory..)
   */
  void parentAppOverloadCeased(ApplicationId id, int type);

  /**
   * Append overload listener
   * @param listener overload listener instance
   * @param lowThreshold low value of overload threshold (for example 0.8 - 1.0 is overload Range)
   * @param highThreshold high value of overload threshold (for example 0.8 - 1.0 is overload Range)
   * @param qIndex overload element index
   */
  void addOverloadListener(OverloadListener listener, double lowThreshold, double highThreshold, int qIndex);

  /**
   * Remove overload listener
   * @param listener overload listener instance
   * @param qIndex overload element index
   */
  void removeOverloadListener(OverloadListener listener, int qIndex);
}
