/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commtesting;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.arquillian.mediaserver.api.MgcpEventListener;
import org.mobicents.arquillian.mediaserver.api.MgcpUnitRequest;
import org.mobicents.commtesting.mgcpUnit.requests.NotifyRequest;
import org.mobicents.commtesting.mgcpUnit.requests.PlayAnnouncementRequest;
import org.mobicents.commtesting.mgcpUnit.utils.EventTypes;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.message.MgcpMessage;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.MgcpResponse;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.utils.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgcpEventListenerImpl
implements MgcpEventListener {
    private Logger logger = Logger.getLogger(MgcpEventListenerImpl.class);
    private ArrayList<MgcpRequest> requests = new ArrayList();
    private ArrayList<MgcpResponse> responses = new ArrayList();
    private ArrayList<MgcpUnitRequest> playAnnouncementRequests = new ArrayList();
    private ArrayList<MgcpUnitRequest> notifyRequests = new ArrayList();
    private MgcpRequest lastRequestMessage;
    private MgcpResponse lastResponseMessage;

    public void process(Event event) {
        MgcpEvent mgcpEvent = (MgcpEvent)event;
        MgcpMessage message = mgcpEvent.getMessage();
        if (mgcpEvent.getEventID() == 1) {
            MgcpRequest req = (MgcpRequest)message;
            this.requests.add(req);
            this.setLastRequestMessage(req);
            this.classifyEvent(mgcpEvent);
        } else {
            MgcpResponse resp = (MgcpResponse)message;
            this.responses.add(resp);
            this.setLastResponseMessage(resp);
        }
        this.logger.debug((Object)("New dispatched eventId: " + message.getTxID() + " message: " + mgcpEvent.getMessage()));
    }

    private void classifyEvent(MgcpEvent event) {
        switch (event.getEventID()) {
            case 1: {
                MgcpRequest request = (MgcpRequest)event.getMessage();
                Text command = request.getCommand();
                if (command.equals((Object)EventTypes.CREATE_CONNECTION) || command.equals((Object)EventTypes.MODIFY_CONNECTION) || command.equals((Object)EventTypes.ENDPOINT_CONFIGURATION)) break;
                if (command.equals((Object)EventTypes.DELETE_CONNECTION)) {
                    if (request.getParameter(Parameter.REASON_CODE) == null) break;
                    break;
                }
                if (command.equals((Object)EventTypes.REQUEST_NOTIFICATION)) {
                    Parameter param = request.getParameter(Parameter.REQUESTED_SIGNALS);
                    if (!param.getValue().toString().contains("AU/pa")) break;
                    this.playAnnouncementRequests.add(new PlayAnnouncementRequest(request));
                    break;
                }
                if (!command.equals((Object)EventTypes.REQUEST_NOTIFY)) break;
                this.notifyRequests.add(new NotifyRequest(request));
                break;
            }
        }
    }

    public Collection<MgcpUnitRequest> getPlayAnnoRequestsReceived() {
        if (!this.playAnnouncementRequests.isEmpty()) {
            return this.playAnnouncementRequests;
        }
        return null;
    }

    public Collection<MgcpUnitRequest> getNotifyRequestsReceived() {
        if (!this.notifyRequests.isEmpty()) {
            return this.notifyRequests;
        }
        return null;
    }

    public boolean checkForSuccessfulResponse(int txId) {
        boolean result = false;
        for (MgcpResponse resp : this.responses) {
            if (resp.getTxID() != txId || resp.getResponseCode() != 200) continue;
            result = true;
        }
        return result;
    }

    public boolean verifyAll() {
        boolean result = false;
        for (MgcpRequest mgcpRequest : this.requests) {
            result = this.checkForSuccessfulResponse(mgcpRequest.getTxID());
        }
        return result;
    }

    public boolean verifyNotify() {
        boolean result = false;
        if (this.playAnnouncementRequests.size() == this.notifyRequests.size()) {
            result = true;
        }
        return result;
    }

    public void clearRequests() {
        this.requests.clear();
    }

    public void clearResponses() {
        this.responses.clear();
    }

    public void clearAll() {
        this.clearRequests();
        this.clearResponses();
    }

    public ArrayList<MgcpRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(ArrayList<MgcpRequest> requests) {
        this.requests = requests;
    }

    public ArrayList<MgcpResponse> getResponses() {
        return this.responses;
    }

    public void setResponses(ArrayList<MgcpResponse> responses) {
        this.responses = responses;
    }

    public MgcpRequest getLastRequestMessage() {
        return this.lastRequestMessage;
    }

    public void setLastRequestMessage(MgcpRequest lastRequestMessage) {
        this.lastRequestMessage = lastRequestMessage;
    }

    public MgcpResponse getLastResponseMessage() {
        return this.lastResponseMessage;
    }

    public void setLastResponseMessage(MgcpResponse lastResponseMessage) {
        this.lastResponseMessage = lastResponseMessage;
    }
}

