/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.extensions.data;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fortuna.ical4j.data.ContentHandlerContext;
import net.fortuna.ical4j.data.DefaultContentHandler;
import net.fortuna.ical4j.extensions.data.ExtendedParameterFactorySupplier;
import net.fortuna.ical4j.extensions.data.ExtendedPropertyFactorySupplier;
import net.fortuna.ical4j.extensions.property.WrTimezone;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZoneRegistry;

public class ExtendedContentHandler
extends DefaultContentHandler {
    private boolean inTimezone;

    public ExtendedContentHandler(Consumer<Calendar> consumer, TimeZoneRegistry tzRegistry) {
        super(consumer, tzRegistry, new ContentHandlerContext().withPropertyFactorySupplier((Supplier)new ExtendedPropertyFactorySupplier()).withParameterFactorySupplier((Supplier)new ExtendedParameterFactorySupplier()));
    }

    public ExtendedContentHandler(Consumer<Calendar> consumer, TimeZoneRegistry tzRegistry, ContentHandlerContext context) {
        super(consumer, tzRegistry, context);
    }

    public void startComponent(String name) {
        super.startComponent(name);
        if ("VTIMEZONE".equalsIgnoreCase(name)) {
            this.inTimezone = true;
        }
    }

    public void endComponent(String name) {
        super.endComponent(name);
        if ("VTIMEZONE".equalsIgnoreCase(name)) {
            this.inTimezone = false;
        }
    }

    public void startProperty(String name) {
        super.startProperty(name);
        if (this.getComponentBuilder() != null && !this.inTimezone) {
            Optional<Property> defaultTimezone = this.calendarProperties.stream().filter(p -> p instanceof WrTimezone).findFirst();
            defaultTimezone.ifPresent(property -> this.propertyBuilder.defaultTimeZone(((WrTimezone)((Object)property)).toZoneId()));
        }
    }
}

