/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class XMLWriter {
    private static final Logger log = Logging.getLoggerInstance(XMLWriter.class);

    public static void write(Node node, Writer writer, boolean indent) throws TransformerException {
        XMLWriter.write(node, writer, indent, false);
    }

    public static void write(Node node, Writer writer, boolean indent, boolean omitxml) throws TransformerException {
        DocumentType dt;
        Document d;
        if (node == null) {
            try {
                writer.write("<null />");
            }
            catch (IOException ioe) {
                log.warn(ioe.getMessage());
            }
            return;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("http://saxon.sf.net/feature/version-warning", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", omitxml ? "yes" : "no");
        if (!omitxml && (d = node.getOwnerDocument()) != null && (dt = d.getDoctype()) != null) {
            transformer.setOutputProperty("doctype-public", dt.getPublicId());
            transformer.setOutputProperty("doctype-system", dt.getSystemId());
        }
        transformer.transform(new DOMSource(node), new StreamResult(writer));
    }

    public static String write(Node node, boolean indent) {
        return XMLWriter.write(node, indent, false);
    }

    public static String write(Node node) {
        return XMLWriter.write(node, false);
    }

    public static String write(Collection<? extends Node> c) {
        StringBuilder b = new StringBuilder();
        for (Node node : c) {
            b.append(XMLWriter.write(node));
        }
        return b.toString();
    }

    public static String write(Node node, boolean indent, boolean omitxml) {
        try {
            StringWriter sw = new StringWriter();
            XMLWriter.write(node, sw, indent, omitxml);
            return sw.toString();
        }
        catch (Exception e) {
            log.fatal("error in XMLWriter. it must be possible to write any node to xml withoud errors:{" + e.getMessage() + "} " + Logging.stackTrace(e));
            return null;
        }
    }

    private XMLWriter() {
    }
}

