/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mmbase.core.event.EventManager;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.Entry;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.DocumentReader;
import org.mmbase.util.xml.EntityResolver;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class UtilReader {
    private static final Logger log = Logging.getLoggerInstance(UtilReader.class);
    public static final String CONFIG_UTILS = "utils";
    public static final String PUBLIC_ID_UTIL_1_0 = "-//MMBase//DTD util config 1.0//EN";
    public static final String DTD_UTIL_1_0 = "util_1_0.dtd";
    public static final String PUBLIC_ID_UTIL = "-//MMBase//DTD util config 1.0//EN";
    public static final String DTD_UTIL = "util_1_0.dtd";
    private static final Map<String, UtilReader> utilReaders = new HashMap<String, UtilReader>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Collection<Map.Entry<String, String>>> maps = new HashMap<String, Collection<Map.Entry<String, String>>>();
    private final String file;
    private ResourceWatcher watcher;

    public static void registerPublicIDs() {
        EntityResolver.registerPublicID("-//MMBase//DTD util config 1.0//EN", "util_1_0.dtd", UtilReader.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UtilReader get(String fileName) {
        UtilReader utilReader = utilReaders.get(fileName);
        if (utilReader == null) {
            Map<String, UtilReader> map = utilReaders;
            synchronized (map) {
                utilReader = new UtilReader(fileName);
                utilReaders.put(fileName, utilReader);
            }
        }
        return utilReader;
    }

    public UtilReader(String fileName) {
        this.file = "utils/" + fileName;
        this.readProperties(this.file);
        this.startWatcher(null);
    }

    public UtilReader(String fileName, ResourceWatcher w) {
        this.file = "utils/" + fileName;
        this.readProperties(this.file);
        this.startWatcher(w);
    }

    public UtilReader(String resourceName, final Runnable onChange) {
        this(resourceName, new ResourceWatcher(ResourceLoader.getConfigurationRoot(), false){

            @Override
            public void onChange(String name) {
                onChange.run();
            }
        });
    }

    protected final void startWatcher(final ResourceWatcher w) {
        EventManager.getInstance().addEventListener(new SystemEventListener(){

            @Override
            public void notify(SystemEvent se) {
                if (se instanceof EventManager.Ready) {
                    UtilReader.this.watcher = new UtilFileWatcher(w);
                    UtilReader.this.watcher.add(UtilReader.this.file);
                    UtilReader.this.watcher.start();
                    EventManager.getInstance().removeEventListener(this);
                }
            }

            @Override
            public int getWeight() {
                return 0;
            }
        });
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.watcher != null) {
            this.watcher.exit();
        }
    }

    public PropertiesMap<String> getProperties() {
        return new PropertiesMap<String>(this.properties);
    }

    public PropertiesMap<Collection<Map.Entry<String, String>>> getMaps() {
        return new PropertiesMap<Collection<Map.Entry<String, String>>>(this.maps);
    }

    public boolean resourceAvailable() {
        try {
            return ResourceLoader.getConfigurationRoot().getResource(this.file).openConnection().getDoInput();
        }
        catch (IOException io) {
            return false;
        }
    }

    protected Map.Entry<String, String> getEntry(DocumentReader reader, String k, String v) {
        return new Entry<String, String>(k, v);
    }

    protected final void readProperties(String s) {
        this.properties.clear();
        this.maps.clear();
        ResourceLoader configLoader = ResourceLoader.getConfigurationRoot();
        List<URL> configList = configLoader.getResourceList(s);
        for (URL url : configList) {
            InputSource is;
            try {
                is = ResourceLoader.getInputSource(url);
            }
            catch (IOException ioe) {
                log.debug(ioe.getMessage() + " for " + url);
                continue;
            }
            if (is != null) {
                log.debug("Reading " + url);
                DocumentReader reader = new DocumentReader(is, false, true, UtilReader.class);
                Element e = reader.getElementByPath("util.properties");
                if (e == null) continue;
                for (Element p : DocumentReader.getChildElements(e, "property")) {
                    String name = reader.getElementAttributeValue(p, "name");
                    String type = reader.getElementAttributeValue(p, "type");
                    if ("mergingmap".equals(type) || "map".equals(type)) {
                        Collection<Map.Entry<String, String>> entryList = null;
                        if ("mergingmap".equals(type)) {
                            entryList = this.maps.get(name);
                        }
                        if (entryList == null) {
                            entryList = new ArrayList<Map.Entry<String, String>>();
                        }
                        for (Element entry : DocumentReader.getChildElements(p, "entry")) {
                            String key = null;
                            String value = null;
                            for (Element keyorvalue : DocumentReader.getChildElements(entry, "*")) {
                                if (keyorvalue.getTagName().equals("key")) {
                                    key = DocumentReader.getElementValue(keyorvalue);
                                    continue;
                                }
                                value = DocumentReader.getNodeTextValue(keyorvalue, false);
                            }
                            if (key == null) continue;
                            entryList.add(this.getEntry(reader, key, value));
                        }
                        if (this.maps.containsKey(name) && !"mergingmap".equals(type)) {
                            log.debug("Property '" + name + "' (" + entryList + ") of " + url + " is shadowed");
                            continue;
                        }
                        this.maps.put(name, entryList);
                        continue;
                    }
                    String value = DocumentReader.getElementValue(p);
                    Map.Entry<String, String> entry = this.getEntry(reader, name, value);
                    if (this.properties.containsKey(entry.getKey())) {
                        log.debug("Property '" + entry.getKey() + "' ('" + entry.getValue() + "') of " + url + " is shadowed");
                        continue;
                    }
                    this.properties.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            log.debug("Resource " + s + " does not exist");
        }
        if (this.properties.isEmpty() && this.maps.isEmpty()) {
            log.service("No properties read from " + configList);
        } else {
            log.service("Read " + this.properties.entrySet() + " from " + configList);
        }
    }

    public String toString() {
        return super.toString() + " " + this.file;
    }

    static {
        UtilReader.registerPublicIDs();
        DocumentReader.utilProperties = UtilReader.get("documentreader.xml").getProperties();
    }

    public static class PropertiesMap<E>
    extends AbstractMap<String, E> {
        private final Map<String, E> wrappedMap;

        public PropertiesMap() {
            this.wrappedMap = new HashMap<String, E>();
        }

        public PropertiesMap(Map<String, E> map) {
            this.wrappedMap = map;
        }

        @Override
        public Set<Map.Entry<String, E>> entrySet() {
            return new EntrySet();
        }

        public E getProperty(String key, E defaultValue) {
            Object result = this.get(key);
            return (E)(result == null ? defaultValue : result);
        }

        private class EntrySetIterator
        implements Iterator<Map.Entry<String, E>> {
            private Iterator<Map.Entry<String, E>> i;

            EntrySetIterator() {
                this.i = PropertiesMap.this.wrappedMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Map.Entry<String, E> next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unmodifiable");
            }
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<String, E>> {
            EntrySet() {
            }

            @Override
            public int size() {
                return PropertiesMap.this.wrappedMap.size();
            }

            @Override
            public Iterator<Map.Entry<String, E>> iterator() {
                return new EntrySetIterator();
            }
        }
    }

    private class UtilFileWatcher
    extends ResourceWatcher {
        private ResourceWatcher wrappedWatcher;

        public UtilFileWatcher(ResourceWatcher f) {
            this.wrappedWatcher = f;
        }

        @Override
        public void onChange(String f) {
            UtilReader.this.readProperties(f);
            if (this.wrappedWatcher != null) {
                this.wrappedWatcher.onChange(f);
            }
        }
    }
}

