/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.SizeMeasurable;
import org.mmbase.util.SizeOf;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class URIResolver
implements javax.xml.transform.URIResolver,
SizeMeasurable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logging.getLoggerInstance(URIResolver.class);
    private EntryList dirs;
    private int hashCode;

    public URIResolver(URL c, boolean overhead) {
        this.hashCode = c.hashCode();
    }

    public URIResolver(URL c) {
        this(c, null);
    }

    private static URL toURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public URIResolver(File f) {
        this(URIResolver.toURL(f), null);
    }

    public URIResolver() {
        this((URL)null, null);
    }

    public URIResolver(File f, EntryList extraDirs) {
        this(URIResolver.toURL(f), extraDirs);
    }

    public URIResolver(URL c, EntryList extraDirs) {
        URL cwd;
        if (log.isDebugEnabled()) {
            log.debug("Creating URI Resolver for " + c);
        }
        if (c == null) {
            File[] roots = File.listRoots();
            if (roots != null && roots.length > 0) {
                try {
                    cwd = roots[0].toURI().toURL();
                }
                catch (Exception e) {
                    cwd = null;
                }
            } else {
                log.warn("No filesystem root available, trying with 'null'");
                cwd = null;
            }
        } else {
            cwd = c;
        }
        this.dirs = new EntryList();
        this.dirs.add(new Entry("", cwd));
        if (extraDirs != null) {
            this.dirs.addAll(extraDirs);
        }
        this.dirs.add(new Entry("mm:", ResourceLoader.getConfigurationRoot()));
        if (extraDirs == null || extraDirs.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("getting hashCode " + cwd.hashCode());
            }
            this.hashCode = cwd.hashCode();
        } else {
            this.hashCode = this.dirs.hashCode();
        }
    }

    public URL getCwd() {
        return ((Entry)this.dirs.get(0)).getDir();
    }

    public String getPath() {
        StringBuilder result = new StringBuilder();
        for (Entry entry : this.dirs) {
            result.append(File.pathSeparatorChar);
            result.append(entry.getDir().toString());
        }
        return result.toString();
    }

    public List<String> getPrefixPath() {
        ArrayList<String> result = new ArrayList<String>();
        for (Entry entry : this.dirs) {
            result.add(entry.getPrefix() + entry.getDir().toString());
        }
        return result;
    }

    public File resolveToFile(String href) {
        return this.resolveToFile(href, null);
    }

    public File resolveToFile(String href, String base) {
        try {
            return new File(this.resolveToURL(href, base).getFile());
        }
        catch (Exception e) {
            return null;
        }
    }

    public URL resolveToURL(String href, String base) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug("Using resolver  " + this + " to resolve href: " + href + "   base: " + base);
        }
        try {
            URL baseURL;
            if (base == null || base.endsWith("javax.xml.transform.stream.StreamSource")) {
                baseURL = this.getCwd();
            } else {
                baseURL = this.resolveToURL(base, null);
                log.debug("Resolved '" + base + "' to " + baseURL);
            }
            URL path = null;
            for (Entry entry : this.dirs) {
                String pref = entry.getPrefix();
                if (!"".equals(pref) && href.startsWith(pref)) {
                    path = entry.getPath(href.substring(entry.getPrefixLength()));
                    if (!log.isTraceEnabled()) break;
                    log.trace("href matches " + entry + " returning " + path);
                    break;
                }
                try {
                    URL u = entry.getPath(href);
                    if (log.isTraceEnabled()) {
                        log.trace("Trying " + u + " " + u.getClass());
                    }
                    if (u.openConnection().getInputStream() == null) continue;
                    log.trace("Ok, breaking");
                    path = u;
                    break;
                }
                catch (MalformedURLException mfe) {
                    log.debug("For " + entry + " " + mfe);
                }
                catch (IOException io) {
                    log.debug("For " + entry + " " + io);
                }
            }
            if (path == null) {
                if (href.startsWith("file:")) {
                    path = new URL(baseURL, href.substring(5));
                } else {
                    log.debug("" + baseURL + " " + href);
                    path = new URL(baseURL, href);
                }
                try {
                    if (path.openConnection().getInputStream() == null) {
                        path = null;
                    }
                }
                catch (Exception e) {
                    path = null;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Returning " + path);
            }
            return path;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            URL u = this.resolveToURL(href, base);
            if (u == null) {
                return null;
            }
            StreamSource source = new StreamSource(u.openStream());
            source.setSystemId(u.toString());
            return source;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof URIResolver) {
            URIResolver res = (URIResolver)o;
            return this.dirs == null ? res.dirs == null || res.dirs.size() == 1 : this.dirs.equals(res.dirs);
        }
        return false;
    }

    @Override
    public int getByteSize() {
        return this.getByteSize(new SizeOf());
    }

    @Override
    public int getByteSize(SizeOf sizeof) {
        return sizeof.sizeof((Object)this.dirs);
    }

    public String toString() {
        return this.getPrefixPath().toString();
    }

    public static void main(String[] argv) throws Exception {
        URIResolver resolver = new URIResolver(new URL("file:///home/mmbase/head/mmbase/edit/wizard/data"));
        System.out.println("Resolving with " + resolver);
        String href = "xsl/list.xsl";
        String base = null;
        System.out.println("href: " + href + " base: " + base + " --> " + resolver.resolveToURL(href, base));
        href = "prompts.xsl";
        base = "file:///home/mmbase/head/mmbase/edit/wizard/data/xsl/base.xsl";
        System.out.println("href: " + href + " base: " + base + " --> " + resolver.resolveToURL(href, base));
        FileOutputStream fos = new FileOutputStream("/tmp/uriresolver.ser");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(resolver);
        oos.close();
        FileInputStream fis = new FileInputStream("/tmp/uriresolver.ser");
        ObjectInputStream ois = new ObjectInputStream(fis);
        URIResolver resolver2 = (URIResolver)ois.readObject();
        ois.close();
        System.out.println("r " + resolver2.resolveToURL("mm:hoi", null).getProtocol());
        href = "xsl/list.xsl";
        base = null;
        System.out.println("href: " + href + " base: " + base + " --> " + resolver2.resolveToURL(href, base));
        href = "prompts.xsl";
        base = "file:///home/mmbase/head/mmbase/edit/wizard/data/xsl/base.xsl";
        System.out.println("href: " + href + " base: " + base + " --> " + resolver2.resolveToURL(href, base));
    }

    static class Entry
    implements Serializable {
        private static final long serialVersionUID = 2L;
        private String prefix;
        private URL dir;
        private ClassLoader classLoader;
        private int prefixLength;

        Entry(String p, URL u) {
            this.prefix = p;
            this.dir = u;
            this.classLoader = null;
            this.prefixLength = this.prefix.length();
        }

        Entry(String p, ClassLoader cl) {
            this.prefix = p;
            this.dir = null;
            this.classLoader = cl;
            this.prefixLength = this.prefix.length();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                out.writeUTF(this.prefix);
                if (this.dir != null && this.dir.getProtocol().equals("mm")) {
                    out.writeObject("mm");
                } else {
                    out.writeObject(this.dir);
                }
            }
            catch (Throwable t) {
                log.warn(t.getMessage(), t);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.prefix = in.readUTF();
                Object o = in.readObject();
                if ("mm:".equals(this.prefix)) {
                    this.classLoader = ResourceLoader.getConfigurationRoot();
                    this.dir = null;
                } else if ("mm".equals(o)) {
                    this.classLoader = ResourceLoader.getConfigurationRoot();
                    this.dir = null;
                } else {
                    this.dir = (URL)o;
                    this.classLoader = null;
                }
            }
            catch (Throwable t) {
                log.warn(t.getMessage(), t);
            }
            this.prefixLength = this.prefix.length();
        }

        String getPrefix() {
            return this.prefix;
        }

        URL getDir() {
            if (this.dir != null) {
                return this.dir;
            }
            return this.classLoader.getResource("");
        }

        URL getPath(String href) throws MalformedURLException {
            if (this.dir != null) {
                return new URL(this.dir, href);
            }
            return this.classLoader.getResource(href);
        }

        int getPrefixLength() {
            return this.prefixLength;
        }

        public String toString() {
            return this.prefix + ":" + (this.dir != null ? this.dir.getClass() + " " + this.dir.toString() : this.classLoader.getClass() + " " + this.classLoader.toString());
        }

        public boolean equals(Object o) {
            if (o instanceof File) {
                return this.dir != null && this.dir.equals(o);
            }
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return this.dir != null ? this.dir.equals(e.dir) : this.classLoader.equals(e.classLoader);
            }
            return false;
        }

        public int hashCode() {
            if (this.dir != null) {
                return this.dir.hashCode();
            }
            return this.classLoader.hashCode();
        }
    }

    public static class EntryList
    extends ArrayList<Entry>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public EntryList add(String p, File d) {
            try {
                this.add(new Entry(p, d.toURI().toURL()));
                return this;
            }
            catch (Exception e) {
                return this;
            }
        }

        public EntryList add(String p, URL u) {
            try {
                this.add(new Entry(p, u));
                return this;
            }
            catch (Exception e) {
                return this;
            }
        }

        public EntryList add(String p, ClassLoader cl) {
            try {
                this.add(new Entry(p, cl));
                return this;
            }
            catch (Exception e) {
                return this;
            }
        }
    }
}

