/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.mmbase.util.Casting;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.DocumentReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Instantiator {
    private static final Logger log = Logging.getLoggerInstance(Instantiator.class);

    public static Class getClass(Element classElement) throws ClassNotFoundException {
        String className;
        if (classElement.getTagName().equals("class")) {
            className = classElement.getAttribute("name");
        } else {
            className = classElement.getAttribute("class");
            if ("".equals(className)) {
                className = classElement.getAttribute("name");
            }
        }
        if ("".equals(className)) {
            className = DocumentReader.getNodeTextValue(classElement);
        }
        return Class.forName(className);
    }

    public static Object getInstance(Element classElement, Object ... args) throws SAXException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return Instantiator.getInstance(Instantiator.getClass(classElement), classElement, args);
    }

    public static Object getInstance(Class claz, Element classElement, Object ... args) throws SAXException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList argTypes = new ArrayList(args.length);
        for (Object arg : args) {
            argTypes.add(arg.getClass());
        }
        Class[] argTypesArray = argTypes.toArray(new Class[argTypes.size()]);
        Constructor<?> constructor = null;
        for (Constructor<?> c : claz.getConstructors()) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length != argTypesArray.length) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i].isAssignableFrom(argTypesArray[i])) continue;
            }
            constructor = c;
            break;
        }
        if (constructor == null) {
            throw new NoSuchMethodError("No constructors found for " + claz + " " + Arrays.asList(args));
        }
        log.debug("Found constructor " + constructor);
        Object o = constructor.newInstance(args);
        Instantiator.setParameters(classElement, o);
        return o;
    }

    public static void setParameters(Element element, Object o) {
        NodeList params = element.getChildNodes();
        Class<?> claz = o.getClass();
        for (int i = 0; i < params.getLength(); ++i) {
            try {
                Node node = params.item(i);
                if (!(node instanceof Element) || !node.getNodeName().equals("param")) continue;
                Element param = (Element)node;
                String name = param.getAttribute("name");
                String value = DocumentReader.getNodeTextValue(param);
                Instantiator.setProperty(name, claz, o, value);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public static void setProperty(String name, Class claz, Object o, String value) {
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        boolean invoked = false;
        Method setProperty = null;
        for (Method m : claz.getMethods()) {
            try {
                if (m.getName().equals(methodName) && m.getParameterTypes().length == 1) {
                    if (invoked) {
                        log.warn("Found multiple matches for setter " + name + " on " + claz);
                    }
                    m.invoke(o, Casting.toType(m.getParameterTypes()[0], value));
                    invoked = true;
                }
                if (!m.getName().equals("setProperty") || m.getParameterTypes().length != 2 || !String.class.isAssignableFrom(m.getParameterTypes()[0])) continue;
                setProperty = m;
            }
            catch (IllegalAccessException ie) {
                log.warn(ie);
            }
            catch (InvocationTargetException ite) {
                invoked = true;
                log.warn(ite.getMessage(), ite);
            }
        }
        if (!invoked && setProperty != null) {
            try {
                invoked = true;
                setProperty.invoke(o, name, Casting.toType(setProperty.getParameterTypes()[1], value));
            }
            catch (IllegalAccessException ie) {
                log.warn(ie);
            }
            catch (InvocationTargetException ite) {
                log.warn(ite);
            }
        }
        if (!invoked) {
            log.warn("Could not set property '" + name + "' on " + o);
        }
    }

    public static Object getInstanceWithSubElement(Element element, Object ... args) throws SAXException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        NodeList childs = element.getChildNodes();
        Object instance = null;
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("class")) continue;
            instance = Instantiator.getInstance((Element)node, args);
            break;
        }
        return instance;
    }
}

