/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.mmbase.util.PublicCloneable;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.DocumentReader;
import org.mmbase.util.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentSerializable
implements Serializable,
PublicCloneable {
    private static final Logger log = Logging.getLoggerInstance(DocumentSerializable.class);
    private static final long serialVersionUID = 1L;
    private Document document;

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.document instanceof Serializable) {
            out.writeObject(this.document);
        } else {
            String string = XMLWriter.write(this.document, false);
            out.writeObject(string);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o instanceof Document) {
            this.document = (Document)o;
        } else {
            try {
                DocumentBuilder documentBuilder = DocumentReader.getDocumentBuilder(false, null, null);
                this.document = documentBuilder.parse(new InputSource(new StringReader("" + o)));
            }
            catch (SAXException e) {
                log.warn(e);
            }
        }
    }

    public DocumentSerializable(Document d) {
        this.document = d;
    }

    public <T> T unwrap(Class<T> iface) {
        return (T)this.document;
    }

    public final Document getDocument() {
        return this.document;
    }

    public String toString() {
        return XMLWriter.write((Node)this.document, false, true);
    }

    public int hashCode() {
        return this.document.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof DocumentSerializable && this.document.isEqualNode(((DocumentSerializable)o).document);
    }

    public Object clone() {
        Document newDocument = DocumentReader.getDocumentBuilder(false, null, null).newDocument();
        Node root = newDocument.importNode(this.document.getDocumentElement(), true);
        newDocument.appendChild(root);
        return new DocumentSerializable(newDocument);
    }
}

