/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.EntityResolver;
import org.mmbase.util.xml.ErrorHandler;
import org.mmbase.util.xml.UtilReader;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentReader {
    private static final Logger log = Logging.getLoggerInstance(DocumentReader.class);
    private static Map<String, DocumentBuilder> documentBuilders = Collections.synchronizedMap(new HashMap());
    protected static final String FILENOTFOUND = "FILENOTFOUND://";
    public static final String PUBLIC_ID_ERROR_1_0 = "-//MMBase//DTD error 1.0//EN";
    public static final String DTD_ERROR_1_0 = "error_1_0.dtd";
    public static final String PUBLIC_ID_ERROR = "-//MMBase//DTD error 1.0//EN";
    public static final String DTD_ERROR = "error_1_0.dtd";
    protected Document document;
    private String systemId;
    static UtilReader.PropertiesMap<String> utilProperties = null;
    private static boolean warnedJAXP12 = false;
    private static boolean warnedXinclude = false;

    public static void registerPublicIDs() {
        EntityResolver.registerPublicID("-//MMBase//DTD error 1.0//EN", "error_1_0.dtd", DocumentReader.class);
    }

    public static boolean validate() {
        Object validate = utilProperties == null ? null : (Object)utilProperties.get("validate");
        return validate == null || validate.equals("true");
    }

    protected static boolean validate(boolean requested) {
        Object validate;
        Object object = validate = utilProperties == null ? null : (Object)utilProperties.get("validate");
        if (validate != null && validate.equals("never")) {
            return false;
        }
        return requested;
    }

    protected DocumentReader() {
    }

    public DocumentReader(InputSource source) {
        this(source, DocumentReader.validate(), null);
    }

    public DocumentReader(InputSource source, boolean validating) {
        this(source, validating, null);
    }

    public DocumentReader(InputSource source, Class<?> resolveBase) {
        this(source, DocumentReader.validate(), resolveBase);
    }

    public DocumentReader(InputSource source, boolean xsd, boolean validating, Class<?> resolveBase) {
        if (source == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        try {
            DocumentBuilder dbuilder;
            this.systemId = source.getSystemId();
            EntityResolver resolver = null;
            if (resolveBase != null) {
                resolver = new EntityResolver(validating, resolveBase);
            }
            if ((dbuilder = DocumentReader.getDocumentBuilder(validating, xsd, null, resolver)) == null) {
                throw new RuntimeException("failure retrieving document builder");
            }
            if (log != null && log.isDebugEnabled()) {
                log.debug("Reading " + source.getSystemId());
            }
            this.document = dbuilder.parse(source);
        }
        catch (SAXException se) {
            throw new RuntimeException("failure reading document: " + source.getSystemId() + "\n" + Logging.stackTrace(se));
        }
        catch (IOException ioe) {
            throw new RuntimeException("failure reading document: " + source.getSystemId() + "\n" + ioe, ioe);
        }
    }

    public DocumentReader(InputSource source, boolean validating, Class<?> resolveBase) {
        this(source, false, validating, resolveBase);
    }

    public DocumentReader(Document doc) {
        this.document = doc;
        this.systemId = doc.getDocumentURI();
    }

    private static DocumentBuilder createDocumentBuilder(boolean validating, boolean xsd, org.xml.sax.ErrorHandler handler, org.xml.sax.EntityResolver resolver) {
        DocumentBuilder db;
        if (handler == null) {
            handler = new ErrorHandler();
        }
        if (resolver == null) {
            resolver = new EntityResolver(validating);
        }
        try {
            DocumentBuilderFactory dfactory;
            block10: {
                block9: {
                    dfactory = DocumentBuilderFactory.newInstance();
                    dfactory.setValidating(validating);
                    try {
                        dfactory.setXIncludeAware(true);
                    }
                    catch (Exception e) {
                        if (warnedXinclude) break block9;
                        log.warn(e + " Your current document builder factory '" + dfactory + "' does not support xi:include.");
                        warnedXinclude = true;
                    }
                }
                if (validating && xsd) {
                    try {
                        dfactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    }
                    catch (IllegalArgumentException iae) {
                        if (warnedJAXP12) break block10;
                        log.warn("The XML parser does not support JAXP 1.2, XSD validation will not work.", iae);
                        warnedJAXP12 = true;
                    }
                }
            }
            dfactory.setNamespaceAware(true);
            db = dfactory.newDocumentBuilder();
            db.setErrorHandler(handler);
            db.setEntityResolver(resolver);
        }
        catch (ParserConfigurationException pce) {
            log.error("a DocumentBuilder cannot be created which satisfies the configuration requested");
            log.error(Logging.stackTrace(pce));
            return null;
        }
        return db;
    }

    public static DocumentBuilder getDocumentBuilder() {
        return DocumentReader.getDocumentBuilder(DocumentReader.validate(), null, null);
    }

    public static DocumentBuilder getDocumentBuilder(boolean validating) {
        return DocumentReader.getDocumentBuilder(validating, null, null);
    }

    public static DocumentBuilder getDocumentBuilder(boolean validating, org.xml.sax.ErrorHandler handler, org.xml.sax.EntityResolver resolver) {
        return DocumentReader.getDocumentBuilder(validating, false, handler, resolver);
    }

    public static DocumentBuilder getDocumentBuilder(boolean validating, boolean xsd, org.xml.sax.ErrorHandler handler, org.xml.sax.EntityResolver resolver) {
        validating = DocumentReader.validate(validating);
        if (handler == null && resolver == null) {
            String key = "" + validating + xsd;
            DocumentBuilder db = documentBuilders.get(key);
            if (db == null) {
                db = DocumentReader.createDocumentBuilder(validating, xsd, null, null);
                documentBuilders.put(key, db);
            }
            return db;
        }
        return DocumentReader.createDocumentBuilder(validating, xsd, handler, resolver);
    }

    public static String getNodeTextValue(Node n) {
        return DocumentReader.getNodeTextValue(n, true);
    }

    public static String getNodeTextValue(Node n, boolean trim) {
        NodeList nl = n.getChildNodes();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node textnode = nl.item(i);
            if (textnode.getNodeType() == 3) {
                String s = textnode.getNodeValue();
                if (trim) {
                    s = s.trim();
                }
                res.append(s);
                continue;
            }
            if (textnode.getNodeType() != 4) continue;
            res.append(textnode.getNodeValue());
        }
        return res.toString();
    }

    public static void setNodeTextValue(Node n, String value) {
        Node child = n.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            n.removeChild(child);
            child = next;
        }
        Text text = n.getOwnerDocument().createTextNode(value);
        n.appendChild(text);
    }

    public static void setPrefix(Document d, String ns, String prefix) {
        NodeList nl = d.getElementsByTagName("*");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node element = nl.item(i);
            if (!ns.equals(element.getNamespaceURI())) continue;
            element.setPrefix(prefix);
        }
    }

    public static boolean hasAttribute(Element element, String nameSpace, String localName) {
        return element.hasAttributeNS(nameSpace, localName) || element.hasAttribute(localName);
    }

    public static String getAttribute(Element element, String nameSpace, String localName) {
        if (element.hasAttributeNS(nameSpace, localName)) {
            return element.getAttributeNS(nameSpace, localName);
        }
        return element.getAttribute(localName);
    }

    public static Document toDocument(Element element) {
        DocumentBuilder documentBuilder = DocumentReader.getDocumentBuilder(false, null, null);
        DOMImplementation impl = documentBuilder.getDOMImplementation();
        Document document = impl.createDocument(element.getNamespaceURI(), element.getLocalName(), null);
        Element dest = document.getDocumentElement();
        Element copy = (Element)document.importNode(element, false);
        NamedNodeMap attributes = copy.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i).cloneNode(true);
            dest.setAttributeNode(attribute);
        }
        NodeList childs = element.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = document.importNode(childs.item(i), true);
            dest.appendChild(child);
        }
        document.normalize();
        return document;
    }

    public static void appendChild(Element parent, Element newChild, String path) {
        String[] p = path.split(",");
        int i = 0;
        Node refChild = null;
        NodeList childs = parent.getChildNodes();
        int j = 0;
        Pattern pattern = null;
        if (p.length > 0) {
            pattern = Pattern.compile("\\A" + p[i] + "\\z");
        }
        boolean matching = false;
        while (j < childs.getLength() && i < p.length) {
            if (childs.item(j) instanceof Element) {
                Element child = (Element)childs.item(j);
                if (pattern.matcher(child.getLocalName()).matches()) {
                    refChild = childs.item(++j);
                    matching = true;
                    continue;
                }
                if (!matching) {
                    refChild = childs.item(j);
                    break;
                }
                pattern = ++i < p.length ? Pattern.compile("\\A" + p[i] + "\\z") : null;
                continue;
            }
            ++j;
        }
        parent.insertBefore(newChild, refChild);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String url) {
        this.systemId = url;
    }

    public String getElementName(Element e) {
        return e.getLocalName();
    }

    public String getElementAttributeValue(String path, String attr) {
        return this.getElementAttributeValue(this.getElementByPath(path), attr);
    }

    public String getElementAttributeValue(Element e, String attr) {
        if (e == null) {
            return "";
        }
        return e.getAttribute(attr);
    }

    public Element getRootElement() {
        if (this.document == null) {
            log.error("Document is not defined, cannot get root element");
        }
        return this.document.getDocumentElement();
    }

    public Element getElementByPath(String path) {
        if (this.document == null) {
            log.error("Document is not defined, cannot get " + path);
        }
        return DocumentReader.getElementByPath(this.document.getDocumentElement(), path);
    }

    public static Element getElementByPath(Element e, String path) {
        StringTokenizer st = new StringTokenizer(path, ".");
        if (!st.hasMoreTokens()) {
            log.error("No tokens in path");
            return null;
        }
        if (e == null) {
            throw new NullPointerException("Cannot follow path on element which is NULL");
        }
        String root = st.nextToken();
        String localName = e.getLocalName();
        if ("error".equals(localName)) {
            log.error("Error occurred : (" + DocumentReader.getElementValue(e) + ")");
            return null;
        }
        if (!root.equals(localName) && !"*".equals(root)) {
            log.error("path [" + path + "] with root (" + root + ") doesn't start with root element (" + localName + "): incorrect xml file(" + e.getOwnerDocument().getDocumentURI() + ")");
            return null;
        }
        block0: while (st.hasMoreTokens()) {
            String tag = st.nextToken();
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String tagName;
                if (nl.item(i) instanceof Element && ((tagName = (e = (Element)nl.item(i)).getLocalName()) == null || tagName.equals(tag) || "*".equals(tag))) continue block0;
            }
            return null;
        }
        return e;
    }

    public String getElementValue(String path) {
        return DocumentReader.getElementValue(this.getElementByPath(path));
    }

    public static String getElementValue(Element e) {
        if (e == null) {
            return "";
        }
        return DocumentReader.getNodeTextValue(e);
    }

    public List<Element> getChildElements(String path) {
        return DocumentReader.getChildElements(this.getElementByPath(path));
    }

    public static List<Element> getChildElements(Element e) {
        return DocumentReader.getChildElements(e, "*");
    }

    public List<Element> getChildElements(String path, String tag) {
        return DocumentReader.getChildElements(this.getElementByPath(path), tag);
    }

    public static List<Element> getChildElements(Element e, String tag) {
        ArrayList<Element> v = new ArrayList<Element>();
        boolean ignoretag = "*".equals(tag);
        if (e != null) {
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getLocalName() == null || n.getNodeType() != 1 || !ignoretag && !n.getLocalName().equalsIgnoreCase(tag)) continue;
                v.add((Element)n);
            }
        }
        return v;
    }

    public Document getDocument() {
        return this.document;
    }

    public static void main(String[] argv) throws Exception {
        ResourceLoader.getSystemRoot().getDocument(argv[0]);
    }
}

