/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.XSLTransformer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableStringTransformer;
import org.mmbase.util.transformers.ListParser;
import org.mmbase.util.transformers.UnknownCodingException;
import org.mmbase.util.transformers.Xml;
import org.mmbase.util.xml.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlField
extends ConfigurableStringTransformer
implements CharTransformer {
    private static final Logger log = Logging.getLoggerInstance(XmlField.class);
    public static final int POORBODY = 5;
    public static final int RICHBODY = 6;
    public static final int HTML_INLINE = 7;
    public static final int HTML_BLOCK = 8;
    public static final int HTML_BLOCK_BR = 9;
    public static final int HTML_BLOCK_NOSURROUNDINGP = 10;
    public static final int HTML_BLOCK_BR_NOSURROUNDINGP = 11;
    public static final int HTML_BLOCK_LIST = 12;
    public static final int HTML_BLOCK_LIST_BR = 13;
    public static final int HTML_BLOCK_LIST_NOSURROUNDINGP = 14;
    public static final int HTML_BLOCK_LIST_BR_NOSURROUNDINGP = 15;
    public static final int ASCII = 51;
    public static final int XHTML = 52;
    private static final String CODING = "UTF-8";
    protected static final boolean SECTIONS = true;
    protected static final boolean NO_SECTIONS = false;
    protected static final boolean LEAVE_NEWLINES = true;
    protected static final boolean REMOVE_NEWLINES = false;
    protected static final boolean SURROUNDING_P = true;
    protected static final boolean NO_SURROUNDING_P = false;
    protected static final boolean LISTS_INSIDE_P = true;
    protected static final boolean LISTS_OUTSIDE_P = false;

    private static boolean isListChar(char c) {
        return c == '-' || c == '*';
    }

    private static String listTag(char c) {
        return c == '-' ? "ul" : "ol";
    }

    static void handleList(StringBuilder obj) {
        String result = ListParser.transform(obj.toString());
        obj.setLength(0);
        obj.append(result);
    }

    private static void handleListLegacy(StringBuilder obj) {
        int pos2;
        int pos1;
        int inList = 0;
        int pos = 0;
        if (obj.length() < 3) {
            return;
        }
        char listChar = '-';
        if (XmlField.isListChar(obj.charAt(0)) && obj.charAt(1) == ' ' && !XmlField.isListChar(obj.charAt(2))) {
            listChar = obj.charAt(0);
            obj.insert(0, "\n");
        } else {
            while (true) {
                pos1 = obj.indexOf("\n- ", pos);
                pos2 = obj.indexOf("\n* ", pos);
                int n = pos = pos1 > 0 && pos1 < pos2 || pos2 < 0 ? pos1 : pos2;
                if (pos == -1 || obj.length() <= pos + 3) break;
                if (!XmlField.isListChar(obj.charAt(pos + 3))) {
                    listChar = obj.charAt(pos + 1);
                    break;
                }
                pos += 3;
            }
        }
        block1: while (pos != -1) {
            if (inList == 0) {
                ++inList;
                obj.delete(pos, pos + 2);
                while (pos < obj.length() && obj.charAt(pos) == ' ') {
                    obj.deleteCharAt(pos);
                }
                if (pos > 0) {
                    obj.insert(pos, "\n");
                    ++pos;
                }
                obj.insert(pos, "<" + XmlField.listTag(listChar) + "><li>");
                pos += 8;
            } else if (obj.length() <= pos + 2 || obj.charAt(pos + 1) != listChar || obj.charAt(pos + 2) != ' ') {
                obj.deleteCharAt(pos);
                obj.insert(pos, "</li></" + XmlField.listTag(listChar) + ">\n");
                pos += 11;
                --inList;
            } else {
                obj.delete(pos, pos + 2);
                while (pos < obj.length() && obj.charAt(pos) == ' ') {
                    obj.deleteCharAt(pos);
                }
                obj.insert(pos, "</li><li>");
                pos += 9;
            }
            if (inList > 0) {
                if ((pos = obj.indexOf("\n", pos)) == -1) break;
                if (pos + 1 == obj.length()) {
                    obj.deleteCharAt(pos);
                    break;
                }
                while (obj.charAt(pos + 1) == ' ') {
                    if ((pos = obj.indexOf("\n", pos + 1)) + 1 != obj.length()) continue;
                    obj.deleteCharAt(pos);
                    break block1;
                }
                continue;
            }
            while (true) {
                pos1 = obj.indexOf("\n- ", pos);
                pos2 = obj.indexOf("\n* ", pos);
                pos = pos1 > 0 && pos1 < pos2 || pos2 < 0 ? pos1 : pos2;
                if (pos == -1 || obj.length() <= pos + 3) continue block1;
                if (!XmlField.isListChar(obj.charAt(pos + 3))) {
                    listChar = obj.charAt(pos + 1);
                    continue block1;
                }
                pos += 3;
            }
        }
        while (inList > 0) {
            obj.insert(obj.length(), "</li></" + XmlField.listTag(listChar) + ">");
            --inList;
        }
    }

    public static void replaceAll(StringBuilder builder, String from, String to) {
        int index = builder.indexOf(from);
        while (index != -1) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
        }
    }

    static void handleEmph(StringBuilder obj, char ch, String tag) {
        XmlField.replaceAll(obj, "" + ch + ch, "&#95;");
        String sch = "" + ch;
        int posEmphOpen = obj.indexOf(sch, 0);
        int posTagOpen = obj.indexOf("<", 0);
        block0: while (posEmphOpen != -1) {
            if (posTagOpen > 0 && posTagOpen < posEmphOpen) {
                int posTagClose = obj.indexOf(">", posTagOpen);
                if (posTagClose == -1) break;
                posEmphOpen = obj.indexOf(sch, posTagClose);
                posTagOpen = obj.indexOf("<", posTagClose);
                continue;
            }
            if (posEmphOpen + 1 >= obj.length()) break;
            if (posEmphOpen > 0 && Character.isLetterOrDigit(obj.charAt(posEmphOpen - 1)) || !Character.isLetterOrDigit(obj.charAt(posEmphOpen + 1))) {
                posEmphOpen = obj.indexOf(sch, posEmphOpen + 1);
                continue;
            }
            int posEmphClose = obj.indexOf(sch, posEmphOpen + 1);
            if (posEmphClose == -1) break;
            while (posEmphClose + 1 < obj.length() && Character.isLetterOrDigit(obj.charAt(posEmphClose + 1))) {
                if ((posEmphClose = obj.indexOf(sch, posEmphClose + 1)) != -1) continue;
                break block0;
            }
            if (posTagOpen > 0 && posEmphClose > posTagOpen) {
                posEmphOpen = obj.indexOf(sch, posTagOpen);
                continue;
            }
            obj.deleteCharAt(posEmphClose);
            obj.insert(posEmphClose, "</" + tag + ">");
            obj.deleteCharAt(posEmphOpen);
            obj.insert(posEmphOpen, "<" + tag + ">");
            posEmphOpen = obj.indexOf(sch, posEmphClose += 7);
            posTagOpen = obj.indexOf("<", posEmphClose);
        }
        XmlField.replaceAll(obj, "&#95;", sch);
    }

    static void preHandleHeaders(StringBuilder obj) {
        int pos;
        int n = pos = obj.length() > 0 && obj.charAt(0) == '$' ? 0 : obj.indexOf("\n$");
        while (pos >= 0) {
            int nextLine;
            char firstChar;
            if (XmlField.isListChar(firstChar = obj.charAt((nextLine = obj.indexOf("\n", ++pos)) + 1))) {
                obj.insert(nextLine, "\n");
                ++pos;
            }
            pos = obj.indexOf("\n$", pos);
        }
    }

    static void handleHeaders(StringBuilder obj) {
        int level = 0;
        int pos = obj.indexOf("<p>$", 0);
        while (pos != -1) {
            int delete;
            int pos2;
            char ch;
            obj.delete(pos, pos + 4);
            int requested_level = 1;
            while ((ch = obj.charAt(pos)) == '$') {
                ++requested_level;
                obj.deleteCharAt(pos);
            }
            if (ch == ' ') {
                obj.deleteCharAt(pos);
            }
            StringBuilder add = new StringBuilder();
            while (requested_level <= level) {
                add.append("</section>");
                --level;
            }
            ++level;
            while (requested_level > level) {
                add.append("<section>");
                ++level;
            }
            add.append("<section><h>");
            obj.insert(pos, add.toString());
            pos += add.length();
            while (true) {
                int pos1 = obj.indexOf("_", pos);
                int posP = obj.indexOf("</p>", pos);
                int posNl = obj.indexOf("\n", pos);
                if (posP > 0 && posP < posNl || posNl == -1) {
                    pos2 = posP;
                    delete = 4;
                } else {
                    pos2 = posNl;
                    delete = 1;
                }
                if (pos1 >= pos2 || pos1 <= 0) break;
                obj.deleteCharAt(pos1);
            }
            pos = pos2;
            if (pos == -1) break;
            obj.delete(pos, pos + delete);
            obj.insert(pos, "</h>");
            pos += 4;
            if (delete == 1) {
                obj.insert(pos, "<p>");
                pos += 3;
            }
            pos = obj.indexOf("<p>$", pos);
        }
        while (level > 0) {
            obj.insert(obj.length(), "</section>");
            --level;
        }
    }

    private static boolean containsListTag(StringBuilder obj, int pos) {
        return obj.length() > pos + 4 && obj.charAt(pos) == '<' && (obj.charAt(pos + 1) == 'u' || obj.charAt(pos + 1) == 'o') && obj.charAt(pos + 2) == 'l' && obj.charAt(pos + 3) == '>';
    }

    static void handleParagraphs(StringBuilder obj, boolean leaveExtraNewLines, boolean surroundingP) {
        XmlField.handleParagraphs(obj, leaveExtraNewLines, surroundingP, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void handleParagraphs(StringBuilder obj, boolean leaveExtraNewLines, boolean surroundingP, boolean placeListsInsideP) {
        log.debug(placeListsInsideP ? "placings lists INSIDE" : "placings lists OUTSIDE");
        boolean inParagraph = true;
        int pos = 0;
        if (surroundingP) {
            int posEnd;
            if (!placeListsInsideP && XmlField.containsListTag(obj, pos) && (posEnd = obj.indexOf("</" + obj.charAt(pos + 1) + "l>", pos + 1)) != -1) {
                pos = posEnd + 5;
                if (obj.length() > pos && obj.charAt(pos) == '\n') {
                    obj.deleteCharAt(pos);
                }
                if (pos >= obj.length()) {
                    return;
                }
            }
            obj.insert(pos, "<p>");
            pos += 3;
        } else if (!placeListsInsideP && XmlField.containsListTag(obj, pos)) {
            obj.insert(pos, "\n\n");
        }
        boolean start = true;
        while (pos < obj.length()) {
            int posEnd;
            if (start) {
                start = false;
                pos = obj.indexOf("\n", pos);
            } else {
                pos = obj.indexOf("\n", pos + 1);
            }
            if (pos == -1) break;
            int skip = 1;
            int l = obj.length();
            while (pos + skip < l && Character.isWhitespace(obj.charAt(pos + skip)) && obj.charAt(pos + skip) != '\n') {
                ++skip;
            }
            if (pos + skip >= l) break;
            if (obj.charAt(pos + skip) != '\n') {
                if (!XmlField.containsListTag(obj, pos + skip)) continue;
                obj.delete(pos, pos + skip);
                if (placeListsInsideP && (posEnd = obj.indexOf("</" + obj.charAt(pos + 1) + "l>", pos + 1)) != -1) {
                    pos = posEnd + 5;
                    if (obj.length() > pos && obj.charAt(pos) == '\n' && (obj.length() == pos + 1 || obj.charAt(pos + 1) != '\n')) {
                        obj.deleteCharAt(pos);
                        continue;
                    }
                    if (obj.length() > pos + 2) {
                        obj.delete(pos, pos + 2);
                    } else {
                        if (obj.length() <= pos + 1) continue;
                        obj.deleteCharAt(pos);
                        continue;
                    }
                }
            } else {
                obj.delete(pos, pos + skip + 1);
            }
            if (leaveExtraNewLines) {
                while (obj.length() > pos && Character.isWhitespace(obj.charAt(pos))) {
                    ++pos;
                }
            } else {
                while (obj.length() > pos && Character.isWhitespace(obj.charAt(pos))) {
                    obj.deleteCharAt(pos);
                }
            }
            if (inParagraph) {
                obj.insert(pos, "</p>");
                inParagraph = false;
                pos += 4;
            }
            skip = 0;
            if (!placeListsInsideP && obj.length() > pos && XmlField.containsListTag(obj, pos) && (posEnd = obj.indexOf("</" + obj.charAt(pos + 1) + "l>", pos + 1)) != -1) {
                pos = posEnd + 5;
                int newlines = 0;
                while (obj.length() > pos + skip && Character.isWhitespace(obj.charAt(pos + skip))) {
                    if (obj.charAt(pos + skip) == '\n') {
                        ++newlines;
                    }
                    if (newlines > 1 && leaveExtraNewLines) {
                        ++skip;
                        continue;
                    }
                    obj.deleteCharAt(pos);
                }
                if (surroundingP && pos == obj.length()) break;
            }
            obj.insert(pos, "<p>");
            pos += skip + 3;
            inParagraph = true;
        }
        if (inParagraph) {
            if (obj.length() > 0 && obj.charAt(obj.length() - 1) == '\n') {
                obj.deleteCharAt(obj.length() - 1);
            }
            if (surroundingP) {
                obj.insert(obj.length(), "</p>");
            }
        }
    }

    static void handleTables(StringBuilder obj) {
        int tables = 0;
        int pos = 0;
        while (pos != -1) {
            int l = obj.length();
            if (pos + 2 < l && obj.charAt(pos) == '{' && obj.charAt(pos + 1) == '|') {
                int skip = 2;
                if (pos + skip < l && obj.charAt(pos + skip) == '-') {
                    ++skip;
                }
                while (pos + skip < l && Character.isWhitespace(obj.charAt(pos + skip)) && obj.charAt(pos + skip) != '\n') {
                    ++skip;
                }
                if (pos + skip >= l) break;
                if (obj.charAt(pos + skip) != '\n') {
                    pos = obj.indexOf("\n", pos + skip);
                    continue;
                }
                ++skip;
                log.debug("ok, this is a table!");
                if (pos > 0 && obj.charAt(pos - 1) == '\n') {
                    obj.deleteCharAt(pos - 1);
                    --pos;
                }
                if (pos > 0 && obj.charAt(pos - 1) == '\n') {
                    obj.deleteCharAt(pos - 1);
                    --pos;
                }
                ++tables;
                obj.delete(pos, pos + skip);
                obj.insert(pos, "</p><table>");
                if (obj.charAt(pos += 11) == '|' && obj.charAt(pos + 1) == '+') {
                    obj.delete(pos, pos + 2);
                    obj.insert(pos, "<caption>");
                    pos += 9;
                    pos = obj.indexOf("\n", pos);
                    obj.deleteCharAt(pos);
                    obj.insert(pos, "</caption>");
                    pos += 10;
                }
                obj.insert(pos, "<tr>");
                pos += 4;
            }
            if (pos >= obj.length()) break;
            if (tables > 0) {
                int end;
                int pipe;
                int nl;
                if (obj.charAt(pos) == '|') {
                    obj.deleteCharAt(pos);
                    if (pos + 2 < obj.length() && obj.charAt(pos) == '-' && obj.charAt(pos + 1) == '\n') {
                        obj.delete(pos, pos + 2);
                        obj.insert(pos, "</tr><tr>");
                        pos += 9;
                        continue;
                    }
                    if (pos + 1 < obj.length() && obj.charAt(pos) == '}' && (pos + 2 == obj.length() || obj.charAt(pos + 1) == '\n')) {
                        obj.delete(pos, pos + 2);
                        obj.insert(pos, "</tr></table>");
                        pos += 13;
                        if (--tables == 0) {
                            obj.insert(pos, "<p>");
                            pos += 3;
                        }
                        while (pos < obj.length() && obj.charAt(pos) == '\n') {
                            obj.deleteCharAt(pos);
                        }
                        continue;
                    }
                    if (pos + 3 < obj.length() && obj.charAt(pos) == '\n' && obj.charAt(pos + 1) == '{' && obj.charAt(pos + 2) == '|') {
                        obj.delete(pos, pos + 3);
                        obj.insert(pos, "<td><table><tr>");
                        pos += 15;
                        ++tables;
                        continue;
                    }
                    obj.insert(pos, "<td>");
                    nl = obj.indexOf("\n", pos += 4);
                    pipe = obj.indexOf("||", pos);
                    int n = end = pipe == -1 || nl < pipe ? nl : pipe;
                    if (end == -1) {
                        end += obj.length();
                    }
                    pos = end;
                    obj.deleteCharAt(pos);
                    obj.insert(pos, "</td>");
                    pos += 5;
                    continue;
                }
                if (obj.charAt(pos) == '!') {
                    obj.deleteCharAt(pos);
                    obj.insert(pos, "<th>");
                    nl = obj.indexOf("\n", pos += 4);
                    pipe = obj.indexOf("!!", pos);
                    int n = end = pipe == -1 || nl < pipe ? nl : pipe;
                    if (end == -1) {
                        end += obj.length();
                    }
                    pos = end;
                    obj.deleteCharAt(pos);
                    obj.insert(pos, "</th>");
                    pos += 5;
                    continue;
                }
                if ((pos = obj.indexOf("\n", pos) + 1) < obj.length()) continue;
                break;
            }
            if ((pos = obj.indexOf("\n", pos) + 1) != 0 && pos < obj.length()) continue;
            break;
        }
        while (tables > 0) {
            obj.insert(pos, "</tr></table>");
            pos += 13;
            if (--tables != 0) continue;
            obj.insert(pos, "<p>");
            pos += 3;
            while (pos < obj.length() && obj.charAt(pos) == '\n') {
                obj.deleteCharAt(pos);
            }
        }
    }

    static void cleanupText(StringBuilder obj) {
        XmlField.replaceAll(obj, ">\n", ">");
        XmlField.replaceAll(obj, "\n", " ");
        int pos = obj.indexOf(" ", 0);
        while (pos != -1) {
            ++pos;
            while (obj.length() > pos && obj.charAt(pos) == ' ') {
                obj.deleteCharAt(pos);
            }
            pos = obj.indexOf(" ", pos);
        }
        XmlField.replaceAll(obj, "\r", "");
    }

    protected static void handleFormat(StringBuilder obj, boolean format) {
        if (format) {
            XmlField.replaceAll(obj, "\r", "\n");
        } else {
            XmlField.cleanupText(obj);
        }
    }

    protected static String prepareDataString(String data) {
        return Xml.XMLEscape(data).replaceAll("\r", "");
    }

    protected static StringBuilder prepareData(String data) {
        return new StringBuilder(XmlField.prepareDataString(data));
    }

    protected static void handleRich(StringBuilder obj, boolean sections, boolean leaveExtraNewLines, boolean surroundingP) {
        XmlField.handleRich(obj, sections, leaveExtraNewLines, surroundingP, false);
    }

    protected static void handleRich(StringBuilder obj, boolean sections, boolean leaveExtraNewLines, boolean surroundingP, boolean placeListsInsideP) {
        if (sections) {
            XmlField.preHandleHeaders(obj);
        }
        XmlField.handleList(obj);
        XmlField.handleTables(obj);
        XmlField.handleParagraphs(obj, leaveExtraNewLines, surroundingP, placeListsInsideP);
        if (sections) {
            XmlField.handleHeaders(obj);
        }
        XmlField.handleEmph(obj, '_', "em");
        XmlField.handleEmph(obj, '*', "strong");
    }

    protected static void handleNewlines(StringBuilder obj) {
        XmlField.replaceAll(obj, "</ul>\n", "</ul>");
        XmlField.replaceAll(obj, "</ol>\n", "</ol>");
        XmlField.replaceAll(obj, "\n", "<br />");
    }

    public static String richToXML(String data, boolean format, boolean placeListsInsideP) {
        StringBuilder obj = XmlField.prepareData(data);
        XmlField.handleRich(obj, true, true, true, placeListsInsideP);
        XmlField.handleNewlines(obj);
        XmlField.handleFormat(obj, format);
        return obj.toString();
    }

    public static String richToXML(String data, boolean format) {
        return XmlField.richToXML(data, format, false);
    }

    public static String richToXML(String data) {
        return XmlField.richToXML(data, false);
    }

    public static String poorToXML(String data, boolean format, boolean placeListsInsideP) {
        StringBuilder obj = XmlField.prepareData(data);
        XmlField.handleRich(obj, true, false, true, placeListsInsideP);
        XmlField.handleFormat(obj, format);
        return obj.toString();
    }

    public static String poorToXML(String data, boolean format) {
        return XmlField.poorToXML(data, format, false);
    }

    public static String poorToXML(String data) {
        return XmlField.poorToXML(data, false);
    }

    public static String richToHTMLBlock(String data, boolean multipibleBrs, boolean surroundingP, boolean placeListsInsideP) {
        StringBuilder obj = XmlField.prepareData(data);
        XmlField.handleRich(obj, false, multipibleBrs, surroundingP, placeListsInsideP);
        XmlField.handleNewlines(obj);
        XmlField.handleFormat(obj, false);
        return obj.toString();
    }

    public static String richToHTMLBlock(String data) {
        return XmlField.richToHTMLBlock(data, false, true, true);
    }

    public static String richToHTMLBlock(String data, boolean multipibleBrs, boolean surroundingP) {
        return XmlField.richToHTMLBlock(data, multipibleBrs, surroundingP, false);
    }

    public static String poorToHTMLInline(String data) {
        StringBuilder obj = XmlField.prepareData(data);
        XmlField.handleFormat(obj, false);
        XmlField.handleEmph(obj, '_', "em");
        XmlField.handleEmph(obj, '*', "strong");
        return obj.toString();
    }

    protected static String XSLTransform(String xslFile, String data) {
        try {
            URL u = ResourceLoader.getConfigurationRoot().getResource("xslt/" + xslFile);
            StringWriter res = new StringWriter();
            XSLTransformer.transform((Source)new StreamSource(new StringReader(data)), u, (Result)new StreamResult(res), null);
            return res.toString();
        }
        catch (TransformerException te) {
            return te.getMessage();
        }
    }

    protected static void validate(String incoming) throws FormatException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Validating " + incoming);
            }
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setValidating(true);
            dfactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = dfactory.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver();
            documentBuilder.setEntityResolver(resolver);
            StringBuilder errorBuff = new StringBuilder();
            ErrorHandler errorHandler = new ErrorHandler(errorBuff);
            documentBuilder.setErrorHandler(errorHandler);
            ByteArrayInputStream input = new ByteArrayInputStream(incoming.getBytes(CODING));
            documentBuilder.parse(input);
            if (!resolver.hasDTD()) {
                throw new FormatException("no doc-type specified for the xml");
            }
            if (errorHandler.errorOrWarning) {
                throw new FormatException("error in xml: \n" + errorBuff.toString());
            }
        }
        catch (ParserConfigurationException pce) {
            throw new FormatException("[sax parser] not well formed xml: " + pce.toString());
        }
        catch (SAXException se) {
            log.debug("", se);
        }
        catch (IOException ioe) {
            throw new FormatException("[io] not well formed xml: " + ioe.toString());
        }
    }

    public XmlField() {
    }

    public XmlField(int to) {
        super(to);
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put("MMXF_ASCII", new Config(XmlField.class, 51, "Converts xml to ASCII (cannoted be reversed)"));
        h.put("MMXF_BODY_RICH", new Config(XmlField.class, 6, "XHTML 2 compliant XML."));
        h.put("MMXF_BODY_POOR", new Config(XmlField.class, 5, "XHTML 2 compliant XML, but withough <br/> tags"));
        h.put("MMXF_HTML_INLINE", new Config(XmlField.class, 7, "Decodes only escaping and with <em>"));
        h.put("MMXF_HTML_BLOCK", new Config(XmlField.class, 8, "Decodes only escaping and with <em>, <p>, <br /> (only one) and <ul>"));
        h.put("MMXF_HTML_BLOCK_BR", new Config(XmlField.class, 9, "Decodes only escaping and with <em>, <p>, <br /> (also multiples) and <ul>"));
        h.put("MMXF_HTML_BLOCK_NOSURROUNDINGP", new Config(XmlField.class, 10, "Decodes only escaping and with <em>, <p>, <br /> (only one) and <ul>"));
        h.put("MMXF_HTML_BLOCK_BR_NOSURROUNDINGP", new Config(XmlField.class, 11, "Decodes only escaping and with <em>, <p>, <br /> (also multiples) and <ul>"));
        h.put("MMXF_HTML_BLOCK_LIST", new Config(XmlField.class, 12, "Decodes only escaping and with <em>, <p>, <br /> (only one) and <ul>, with <ul> inside the <p>"));
        h.put("MMXF_HTML_BLOCK_LIST_NOSURROUNDINGP", new Config(XmlField.class, 14, "Decodes only escaping and with <em>, <p>, <br /> (only one) and <ul>, with <ul> inside the <p>"));
        h.put("MMXF_HTML_BLOCK_LIST_BR", new Config(XmlField.class, 13, "Decodes only escaping and with <em>, <p>, <br /> (also multiples) and <ul>, with <ul> inside the <p>"));
        h.put("MMXF_HTML_BLOCK_LIST_BR_NOSURROUNDINGP", new Config(XmlField.class, 15, "Decodes only escaping and with <em>, <p>, <br /> (also multiples) and <ul>, with <ul> inside the <p>"));
        h.put("MMXF_XHTML", new Config(XmlField.class, 52, "Converts to piece of XHTML"));
        return h;
    }

    @Override
    public String transform(String data) {
        switch (this.to) {
            case 5: 
            case 6: {
                throw new UnsupportedOperationException();
            }
            case 51: {
                return XmlField.XSLTransform("text.xslt", data);
            }
            case 7: 
            case 8: 
            case 9: {
                throw new UnsupportedOperationException("Cannot transform");
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    @Override
    public String transformBack(String r) {
        String result = null;
        switch (this.to) {
            case 6: {
                result = XmlField.richToXML(r);
                break;
            }
            case 5: {
                result = XmlField.poorToXML(r);
                break;
            }
            case 8: {
                result = XmlField.richToHTMLBlock(r, false, true, true);
                break;
            }
            case 9: {
                result = XmlField.richToHTMLBlock(r, true, true, true);
                break;
            }
            case 10: {
                result = XmlField.richToHTMLBlock(r, false, false, true);
                break;
            }
            case 11: {
                result = XmlField.richToHTMLBlock(r, true, false, true);
                break;
            }
            case 12: {
                result = XmlField.richToHTMLBlock(r, false, true, false);
                break;
            }
            case 13: {
                result = XmlField.richToHTMLBlock(r, true, true, false);
                break;
            }
            case 14: {
                result = XmlField.richToHTMLBlock(r, false, false, false);
                break;
            }
            case 15: {
                result = XmlField.richToHTMLBlock(r, true, false, false);
                break;
            }
            case 7: {
                result = XmlField.poorToHTMLInline(r);
                break;
            }
            case 51: {
                throw new UnsupportedOperationException("Cannot transform");
            }
            default: {
                throw new UnknownCodingException(this.getClass(), this.to);
            }
        }
        return result;
    }

    @Override
    public String getEncoding() {
        switch (this.to) {
            case 6: {
                return "MMXF_BODY_RICH";
            }
            case 5: {
                return "MMXF_BODY_POOR";
            }
            case 8: {
                return "MMXF_HTML_BLOCK";
            }
            case 9: {
                return "MMXF_HTML_BLOCK_BR";
            }
            case 10: {
                return "MMXF_HTML_BLOCK_NOSURROUNDINGP";
            }
            case 11: {
                return "MMXF_HTML_BLOCK_BR_NOSURROUNDINGP";
            }
            case 12: {
                return "MMXF_HTML_BLOCK_LIST";
            }
            case 13: {
                return "MMXF_HTML_BLOCK_LIST_BR";
            }
            case 14: {
                return "MMXF_HTML_BLOCK_LIST_NOSURROUNDINGP";
            }
            case 15: {
                return "MMXF_HTML_BLOCK_LIST_BR_NOSURROUNDINGP";
            }
            case 7: {
                return "MMXF_HTML_INLINE";
            }
            case 51: {
                return "MMXF_ASCII";
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        boolean errorOrWarning;
        StringBuilder errorBuff;

        ErrorHandler(StringBuilder errorBuff) {
            this.errorBuff = errorBuff;
            this.errorOrWarning = false;
        }

        @Override
        public void fatalError(SAXParseException exc) {
            this.errorBuff.append("FATAL[").append(this.getLocationString(exc)).append("]:").append(exc.getMessage()).append("\n");
            this.errorOrWarning = true;
        }

        @Override
        public void error(SAXParseException exc) {
            this.errorBuff.append("Error[").append(this.getLocationString(exc)).append("]: ").append(exc.getMessage()).append("\n");
            this.errorOrWarning = true;
        }

        @Override
        public void warning(SAXParseException exc) {
            this.errorBuff.append("Warning[").append(this.getLocationString(exc)).append("]:").append(exc.getMessage()).append("\n");
            this.errorOrWarning = true;
        }

        private String getLocationString(SAXParseException ex) {
            StringBuilder str = new StringBuilder();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            }
            str.append(" line:");
            str.append(ex.getLineNumber());
            str.append(" column:");
            str.append(ex.getColumnNumber());
            return str.toString();
        }
    }

    protected static class FormatException
    extends Exception {
        FormatException(String msg) {
            super(msg);
        }
    }
}

