/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URLDecoder;
import org.mmbase.util.ReaderInputStream;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class UrlEscaper
extends ReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(UrlEscaper.class);
    private static final int BUF_SIZE = 100;
    private static final boolean[] isacceptable = new boolean[]{false, true, false, false, false, false, false, false, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int HEX_ESCAPE = 37;
    public static final UrlEscaper INSTANCE = new UrlEscaper();

    @Override
    public Writer transform(Reader r, Writer w) {
        UrlEscaper.escape(new BufferedInputStream(new ReaderInputStream(r, "UTF-8")), w);
        return w;
    }

    public static void escape(BufferedInputStream r, Writer w) {
        byte[] buf = new byte[100];
        try {
            int n = r.read(buf, 0, 100);
            while (n > 0) {
                for (int i = 0; i < n; ++i) {
                    int a = buf[i] & 0xFF;
                    if (a >= 32 && a < 128 && isacceptable[a - 32]) {
                        w.write((char)a);
                        continue;
                    }
                    w.write(37);
                    w.write(hex[a >> 4]);
                    w.write(hex[a & 0xF]);
                }
                n = r.read(buf, 0, 100);
            }
        }
        catch (IOException ioe) {
            log.warn(ioe.getMessage(), ioe);
        }
    }

    @Override
    public Writer transformBack(Reader reader, Writer writer) {
        BufferedReader br = new BufferedReader(reader, 100);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                writer.write(URLDecoder.decode(line, "UTF-8"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return writer;
    }

    public static void main(String[] args) {
        UrlEscaper e = new UrlEscaper();
        for (String arg : args) {
            log.info("Original : '" + arg + "'");
            String escaped = e.transform(arg);
            log.info("Escaped : '" + escaped + "'");
            log.info("Unescaped again : '" + e.transformBack(escaped) + "'");
        }
    }
}

