/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class Trimmer
extends ReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(Trimmer.class);

    @Override
    public String transform(String s) {
        return s.trim();
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        StringBuilder word = new StringBuilder();
        StringBuilder space = new StringBuilder();
        try {
            log.trace("Starting trim");
            int c = r.read();
            while (c != -1 && Character.isWhitespace((char)c)) {
                c = r.read();
            }
            boolean inWord = true;
            do {
                if (Character.isWhitespace((char)c)) {
                    if (inWord) {
                        w.write(word.toString());
                        word.setLength(0);
                        inWord = false;
                    }
                    space.append((char)c);
                    continue;
                }
                if (!inWord) {
                    w.write(space.toString());
                    space.setLength(0);
                    inWord = true;
                }
                word.append((char)c);
            } while ((c = r.read()) != -1);
            if (inWord) {
                w.write(word.toString());
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "TRIMMER";
    }
}

