/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ByteTransformer;
import org.mmbase.util.transformers.ByteTransformerLink;

public class TransformingOutputStream
extends PipedOutputStream {
    private static final Logger log = Logging.getLoggerInstance(TransformingOutputStream.class);
    private final OutputStream out;
    private final ByteTransformerLink link;

    public TransformingOutputStream(OutputStream out, ByteTransformer transformer) throws IOException {
        this.out = out;
        PipedInputStream r = new PipedInputStream();
        this.link = new ByteTransformerLink(transformer, r, out, false);
        this.connect(r);
        ThreadPools.filterExecutor.execute(this.link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitUntilReady() throws IOException {
        super.close();
        try {
            while (!this.link.ready()) {
                ByteTransformerLink byteTransformerLink = this.link;
                synchronized (byteTransformerLink) {
                    this.link.wait();
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            log.warn("" + ie);
        }
    }

    @Override
    public void close() throws IOException {
        this.waitUntilReady();
        this.out.close();
    }

    public Throwable getException() {
        return this.link.getException();
    }
}

