/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.ReaderTransformer;

public class SpaceRemover
extends ReaderTransformer
implements CharTransformer {
    private static final Logger log = Logging.getLoggerInstance(SpaceRemover.class);

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            log.debug("Starting to remove all space.");
            int c = r.read();
            while (c != -1 && Character.isWhitespace((char)c)) {
                c = r.read();
            }
            boolean writing = true;
            while (c != -1) {
                if (Character.isWhitespace((char)c)) {
                    writing = false;
                } else {
                    if (!writing) {
                        w.write(32);
                        writing = true;
                    }
                    w.write(c);
                }
                c = r.read();
            }
            log.debug("Finished");
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "SPACEREMOVER";
    }
}

