/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.BufferedReaderTransformer;

public class SpaceReducer
extends BufferedReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(SpaceReducer.class);

    @Override
    protected boolean transform(PrintWriter bw, String line, BufferedReaderTransformer.Status status) {
        boolean result;
        block3: {
            List<Tag> tagsToPass;
            SpaceReducerStatus srStatus;
            block2: {
                srStatus = (SpaceReducerStatus)status;
                tagsToPass = srStatus.getTagsToPass();
                result = false;
                if (!line.trim().equals("") || srStatus.getCurrentlyOpen() != null) {
                    String cleaned = line.replaceAll("([^ ])\\s+", "$1 ");
                    bw.write(cleaned);
                    result = true;
                }
                if (srStatus.getCurrentlyOpen() == null) break block2;
                srStatus.getCurrentlyOpen().setLine(line);
                if (!srStatus.getCurrentlyOpen().hasClosed()) break block3;
                srStatus.setCurrentlyOpen(null);
                break block3;
            }
            for (Tag tag : tagsToPass) {
                tag.setLine(line);
                if (!tag.hasOpened()) continue;
                srStatus.setCurrentlyOpen(tag);
                break;
            }
        }
        return result;
    }

    protected Writer transform2(Reader r, Writer w) {
        int space = 1;
        int nl = 1;
        StringBuilder indent = new StringBuilder();
        int l = 0;
        int lines = 0;
        try {
            log.debug("Starting spacereducing");
            int c = r.read();
            while (c != -1) {
                if (c == 10 || c == 13) {
                    if (nl == 0) {
                        w.write(10);
                    }
                    ++nl;
                    l = 0;
                    space = 0;
                    indent.setLength(0);
                } else if (Character.isWhitespace((char)c)) {
                    if (space == 0 && l > 0) {
                        w.write(32);
                    }
                    if (l == 0) {
                        indent.append((char)c);
                    }
                    ++space;
                } else {
                    if (l == 0 && space > 0) {
                        w.write(indent.toString());
                        indent.setLength(0);
                    }
                    space = 0;
                    lines += nl;
                    nl = 0;
                    ++l;
                    w.write(c);
                }
                c = r.read();
            }
            log.debug("Finished: read " + lines + " lines");
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    protected String transform2(String r) {
        if (r == null) {
            return null;
        }
        Writer sw = this.transform2(new StringReader(r), new StringWriter());
        return sw.toString();
    }

    @Override
    public String toString() {
        return "SPACEREDUCER";
    }

    @Override
    public BufferedReaderTransformer.Status createNewStatus() {
        return new SpaceReducerStatus();
    }

    protected static class SpaceReducerStatus
    extends BufferedReaderTransformer.Status {
        private final List<Tag> tagsToPass = new ArrayList<Tag>();
        private Tag currentlyOpen = null;

        public SpaceReducerStatus() {
            this.tagsToPass.add(new Tag("pre"));
            this.tagsToPass.add(new Tag("textarea"));
        }

        public List<Tag> getTagsToPass() {
            return this.tagsToPass;
        }

        public Tag getCurrentlyOpen() {
            return this.currentlyOpen;
        }

        public void setCurrentlyOpen(Tag currentlyOpen) {
            this.currentlyOpen = currentlyOpen;
        }
    }

    protected static class Tag {
        private boolean hasOpened = false;
        private boolean hasClosed = false;
        private Pattern openingPattern;
        private Pattern closingPattern;
        private Pattern noBodyPattern;
        private String name;

        public Tag(String name) {
            this.openingPattern = Pattern.compile("<[\\s]*" + name + "(\\s+[a-zA-Z]+\\=\"[\\S]+\")*\\s*>", 2);
            this.closingPattern = Pattern.compile("<[\\s]*/\\s*" + name + "\\s*>", 2);
            this.noBodyPattern = Pattern.compile("<[\\s]*" + name + "\\s+([a-zA-Z]+\\=\"[\\S]+\")*\\s*/\\s*>", 2);
            this.name = name;
        }

        public void setLine(String line) {
            int closing;
            int opening = this.countOccurences(this.openingPattern, line = this.removeTagsWithoutBody(line));
            this.hasOpened = opening > (closing = this.countOccurences(this.closingPattern, line));
            this.hasClosed = closing > opening;
        }

        private int countOccurences(Pattern pattern, String line) {
            Matcher m = pattern.matcher(line);
            int counter = 0;
            while (m.find()) {
                ++counter;
                line = line.substring(m.end(), line.length());
                m = pattern.matcher(line);
            }
            return counter;
        }

        private String removeTagsWithoutBody(String line) {
            Matcher m = this.noBodyPattern.matcher(line);
            while (m.find()) {
                line = line.substring(0, m.start()) + line.substring(m.end(), line.length());
                m = this.noBodyPattern.matcher(line);
            }
            return line;
        }

        public boolean hasOpened() {
            return this.hasOpened;
        }

        public boolean hasClosed() {
            return this.hasClosed;
        }

        public String toString() {
            return this.name;
        }
    }
}

