/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.util.regex.Pattern;
import org.mmbase.util.transformers.StringTransformer;

public class RomanTransformer
extends StringTransformer {
    public static final Pattern NUMERIC = Pattern.compile("\\d+");
    public static final Pattern ROMAN = Pattern.compile("(?i)[ivxlcdm]+");
    public static final int I = 1;
    public static final int V = 5;
    public static final int X = 10;
    public static final int L = 50;
    public static final int C = 100;
    public static final int D = 500;
    public static final int M = 1000;

    public static int romanToDecimal(char r) {
        if (r == 'i') {
            return 1;
        }
        if (r == 'v') {
            return 5;
        }
        if (r == 'x') {
            return 10;
        }
        if (r == 'l') {
            return 50;
        }
        if (r == 'c') {
            return 100;
        }
        if (r == 'd') {
            return 500;
        }
        if (r == 'm') {
            return 1000;
        }
        return 0;
    }

    public static char decimalToRomanDigit(int i) {
        switch (i) {
            case 1000: {
                return 'm';
            }
            case 500: {
                return 'd';
            }
            case 100: {
                return 'c';
            }
            case 50: {
                return 'l';
            }
            case 10: {
                return 'x';
            }
            case 5: {
                return 'v';
            }
            case 1: {
                return 'i';
            }
        }
        return ' ';
    }

    public static int romanToDecimal(String roman) {
        roman = roman.toLowerCase();
        int tot = 0;
        int mode = 1;
        for (int i = roman.length() - 1; i >= 0; --i) {
            int value = RomanTransformer.romanToDecimal(roman.charAt(i));
            if (value > mode) {
                mode = value;
            }
            if (value < mode) {
                tot -= value;
                continue;
            }
            tot += value;
        }
        return tot;
    }

    public static String decimalToRoman(int value) {
        if (value < 1 || value > 3999) {
            return "" + value;
        }
        StringBuilder buf = new StringBuilder();
        int mode = 1000;
        while (value > 0) {
            while (value < mode) {
                mode /= 10;
            }
            if (value >= 9 * mode && mode < 1000) {
                buf.append(RomanTransformer.decimalToRomanDigit(mode));
                buf.append(RomanTransformer.decimalToRomanDigit(mode * 10));
                value -= 9 * mode;
                continue;
            }
            if (value >= 4 * mode && mode < 1000) {
                if (value < 5 * mode) {
                    buf.append(RomanTransformer.decimalToRomanDigit(mode));
                    value += mode;
                }
                buf.append(RomanTransformer.decimalToRomanDigit(5 * mode));
                value -= 5 * mode;
            }
            while (value >= mode) {
                buf.append(RomanTransformer.decimalToRomanDigit(mode));
                value -= mode;
            }
        }
        return buf.toString();
    }

    @Override
    public String transform(String r) {
        try {
            int i = Integer.parseInt(r);
            return RomanTransformer.decimalToRoman(i);
        }
        catch (Exception e) {
            return r;
        }
    }

    @Override
    public String transformBack(String r) {
        return "" + RomanTransformer.romanToDecimal(r);
    }

    @Override
    public String toString() {
        return "ROMAN";
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Use roman or decimal argument");
            return;
        }
        if (argv.length == 1) {
            if (NUMERIC.matcher(argv[0]).matches()) {
                System.out.println(RomanTransformer.decimalToRoman(Integer.parseInt(argv[0])));
            } else {
                System.out.println(RomanTransformer.romanToDecimal(argv[0]));
            }
        }
        if (argv.length == 2) {
            int start = NUMERIC.matcher(argv[0]).matches() ? Integer.parseInt(argv[0]) : RomanTransformer.romanToDecimal(argv[0]);
            int end = NUMERIC.matcher(argv[1]).matches() ? Integer.parseInt(argv[1]) : RomanTransformer.romanToDecimal(argv[1]);
            for (int i = start; i <= end; ++i) {
                System.out.println(RomanTransformer.decimalToRoman(i));
            }
        }
    }
}

