/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mmbase.util.Entry;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ChunkedTransformer;
import org.mmbase.util.xml.UtilReader;

public class RegexpReplacer
extends ChunkedTransformer<Pattern> {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logging.getLoggerInstance(RegexpReplacer.class);
    private static final Map<String, UtilReader> utilReaders = new HashMap<String, UtilReader>();
    protected static final Collection<Entry<Pattern, String>> regexps = new ArrayList<Entry<Pattern, String>>();
    protected boolean replaceInA = false;

    public RegexpReplacer(int i) {
        super(i);
    }

    public RegexpReplacer() {
        super(3);
    }

    protected Collection<Entry<Pattern, String>> getPatterns() {
        return regexps;
    }

    protected String getConfigFile() {
        return "regexps.xml";
    }

    protected void readDefaultPatterns(Collection<Entry<Pattern, String>> patterns) {
    }

    protected final void readPatterns(Collection<Entry<Pattern, String>> patterns) {
        UtilReader utilReader = utilReaders.get(this.getClass().getName());
        if (utilReader == null) {
            utilReader = new UtilReader(this.getConfigFile(), new PatternWatcher(patterns));
            utilReaders.put(this.getClass().getName(), utilReader);
        }
        patterns.clear();
        Collection regs = (Collection)utilReader.getMaps().get("regexps");
        if (regs != null) {
            RegexpReplacer.addPatterns(regs, patterns);
        } else {
            this.readDefaultPatterns(patterns);
        }
    }

    protected static void addPatterns(Collection<Map.Entry<String, String>> list, Collection<Entry<Pattern, String>> patterns) {
        if (list != null) {
            for (Map.Entry<String, String> entry : list) {
                Pattern p = Pattern.compile(entry.getKey());
                patterns.add(new Entry<Pattern, String>(p, entry.getValue()));
            }
        }
    }

    @Override
    protected boolean replace(String string, Writer w, ChunkedTransformer.Status status) throws IOException {
        if (!status.inA || this.replaceInA) {
            boolean r = false;
            AbstractList chunks = this.onlyFirstPattern ? new LinkedList() : new ArrayList(1);
            chunks.add(new Chunk(string));
            block0: for (Map.Entry entry : this.getPatterns()) {
                Pattern p = (Pattern)entry.getKey();
                if (this.onlyFirstMatch && status.used.contains(p)) continue;
                ListIterator<Chunk> i = chunks.listIterator();
                while (i.hasNext()) {
                    Chunk chunk = (Chunk)i.next();
                    if (this.onlyFirstPattern && chunk.replaced) continue;
                    Matcher m = p.matcher(chunk.string);
                    String replacement = (String)entry.getValue();
                    boolean result = false;
                    result = this.to == 1 || this.to == 3 ? m.matches() : m.find();
                    if (!result) continue;
                    r = true;
                    StringBuffer sb = new StringBuffer();
                    do {
                        ++status.replaced;
                        m.appendReplacement(sb, replacement);
                    } while (!this.onlyFirstMatch && !this.onlyFirstPattern && this.to != 1 && this.to != 3 && (result = m.find()));
                    if (this.onlyFirstPattern) {
                        i.remove();
                        int s = m.start();
                        if (s > 0) {
                            i.add(new Chunk(sb.toString().substring(0, s)));
                            sb.delete(0, s);
                        }
                        i.add(new Chunk(sb.toString(), true));
                        sb.setLength(0);
                        m.appendTail(sb);
                        i.add(new Chunk(sb.toString()));
                        i.previous();
                    } else {
                        m.appendTail(sb);
                        i.set(new Chunk(sb.toString()));
                    }
                    if (!this.onlyFirstMatch && this.to != 1 && this.to != 3) continue;
                    continue block0;
                }
            }
            for (Chunk chunk : chunks) {
                w.write(chunk.string);
            }
            return r;
        }
        w.write(string);
        return false;
    }

    @Override
    protected final String base() {
        return "REGEXPS";
    }

    @Override
    public String toString() {
        return this.getEncoding() + " " + this.getPatterns();
    }

    public static void main(String[] arg) {
        StringBuffer b = new StringBuffer();
        Pattern p = Pattern.compile(arg[0]);
        String input = arg[1];
        Matcher m = p.matcher(input);
        while (m.find()) {
            b.append("'");
            m.appendReplacement(b, m.group().toUpperCase());
            b.append("'");
            System.out.println("s: " + m.start() + " e: " + m.end() + "g: " + m.group());
        }
        b.append("X");
        m.appendTail(b);
        System.out.println("buf : " + b);
        log.debug(m);
    }

    static {
        new RegexpReplacer().readPatterns(regexps);
    }

    private class Chunk {
        String string;
        boolean replaced = false;

        Chunk(String s) {
            this.string = s;
        }

        Chunk(String s, boolean r) {
            this.string = s;
            this.replaced = r;
        }

        public String toString() {
            return "'" + this.string + "'" + (this.replaced ? "." : "");
        }
    }

    protected class PatternWatcher
    extends ResourceWatcher {
        protected Collection<Entry<Pattern, String>> patterns;

        PatternWatcher(Collection<Entry<Pattern, String>> p) {
            this.patterns = p;
        }

        @Override
        public void onChange(String file) {
            RegexpReplacer.this.readPatterns(this.patterns);
        }
    }
}

