/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import org.mmbase.util.transformers.StringTransformer;

public class RadixTransformer
extends StringTransformer {
    protected int radix = 36;

    public void setRadix(int r) {
        this.radix = r;
    }

    public int getRadix() {
        return this.radix;
    }

    @Override
    public String transform(String r) {
        try {
            long l = Long.parseLong(r);
            return Long.toString(l, this.radix);
        }
        catch (Exception e) {
            return r;
        }
    }

    @Override
    public String transformBack(String r) {
        return "" + Long.parseLong(r, this.radix);
    }

    @Override
    public String toString() {
        return "RADIX" + this.radix;
    }
}

