/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class LoggerCharTransformer
extends ReaderTransformer {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = Logging.getLoggerInstance(LoggerCharTransformer.class);
    public static final LoggerCharTransformer INSTANCE = new LoggerCharTransformer();
    private boolean debugChars = false;

    public void setDebugChars(boolean d) {
        this.debugChars = d;
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        LOG.service("Logging " + r + " -> " + w);
        try {
            long size = 0L;
            char[] buffer = new char[1024];
            int n = 0;
            while (-1 != (n = r.read(buffer))) {
                w.write(buffer, 0, n);
                size += (long)n;
                if (this.debugChars) {
                    for (int i = 0; i < n; ++i) {
                        LOG.service("char " + (size - (long)n + (long)i) + ": " + buffer[i] + " (" + buffer[i] + ")");
                    }
                    continue;
                }
                LOG.service(new String(buffer, 0, n));
            }
            LOG.service("Ready " + size + " bytes");
        }
        catch (IOException ie) {
            LOG.error(ie.getMessage(), ie);
        }
        return w;
    }
}

