/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mmbase.util.transformers.ListParserConstants;
import org.mmbase.util.transformers.ListParserTokenManager;
import org.mmbase.util.transformers.ParseException;
import org.mmbase.util.transformers.SimpleCharStream;
import org.mmbase.util.transformers.Token;
import org.mmbase.util.transformers.TokenMgrError;

public class ListParser
implements ListParserConstants {
    int curDepth = 0;
    boolean begin = true;
    LinkedList<Character> stack = new LinkedList();
    public ListParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[2];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static String transform(String inString) {
        StringReader reader = new StringReader(inString);
        ListParser parser = new ListParser(reader);
        StringBuilder buffer = new StringBuilder();
        try {
            parser.start(buffer);
        }
        catch (TokenMgrError e) {
            throw new IllegalStateException();
        }
        catch (ParseException e) {
            throw new IllegalStateException();
        }
        return buffer.toString();
    }

    int getDepth(Token t) {
        return t.image.length() - (this.begin ? 1 : 2);
    }

    char getType(Token t, int depth) {
        return t.image.charAt(depth - 1 + (this.begin ? 0 : 1)) == '*' ? (char)'o' : 'u';
    }

    void open(StringBuilder buf, char type) {
        ++this.curDepth;
        this.stack.addFirst(Character.valueOf(type));
        if (!this.begin && this.curDepth == 1) {
            buf.append('\n');
        }
        buf.append('<').append(type).append("l>");
    }

    void close(StringBuilder buf) {
        --this.curDepth;
        char t = this.stack.removeFirst().charValue();
        buf.append("</li></").append(t).append("l>");
        if (this.curDepth > 0) {
            buf.append("</li>");
        }
    }

    void handleList(StringBuilder buf, Token t) {
        int depth = this.getDepth(t);
        char type = this.getType(t, depth);
        if (depth == this.curDepth + 1) {
            this.open(buf, type);
        } else if (depth == this.curDepth - 1) {
            this.close(buf);
        } else if (depth == this.curDepth) {
            buf.append("</li>");
        }
        buf.append("<li>");
    }

    void endLists(StringBuilder buf) {
        while (this.stack.size() > 0) {
            this.close(buf);
        }
    }

    public static void main(String[] argv) throws ParseException, InterruptedException {
        System.out.println(ListParser.transform(argv[0]));
    }

    public final void start(StringBuilder buf) throws ParseException {
        block15: {
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: {
                        Token t = this.jj_consume_token(3);
                        this.begin = false;
                        this.handleList(buf, t);
                        continue block11;
                    }
                    case 4: {
                        Token t = this.jj_consume_token(4);
                        this.begin = false;
                        this.handleList(buf, t);
                        continue block11;
                    }
                    case 1: {
                        Token t = this.jj_consume_token(1);
                        if (this.begin) {
                            this.handleList(buf, t);
                            this.begin = false;
                            continue block11;
                        }
                        buf.append(t.image);
                        continue block11;
                    }
                    case 2: {
                        Token t = this.jj_consume_token(2);
                        if (this.begin) {
                            this.handleList(buf, t);
                            this.begin = false;
                            continue block11;
                        }
                        buf.append(t.image);
                        continue block11;
                    }
                    case 5: {
                        this.jj_consume_token(5);
                        if (this.begin) {
                            buf.append("\n");
                            continue block11;
                        }
                        this.endLists(buf);
                        buf.append("\n");
                        continue block11;
                    }
                    case 6: {
                        Token t = this.jj_consume_token(6);
                        this.begin = false;
                        buf.append(t.image);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
        this.endLists(buf);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{126, 126};
    }

    public ListParser(InputStream stream) {
        this(stream, null);
    }

    public ListParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ListParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ListParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ListParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ListParser(ListParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ListParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[7];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 2; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 7; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ListParser.jj_la1_init_0();
    }
}

