/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class Identifier
extends ReaderTransformer {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logging.getLoggerInstance(Identifier.class);
    private String whitespace = "_";

    public void setWhitespaceReplacer(String ws) {
        this.whitespace = ws;
    }

    public String getWhitespaceReplacer() {
        return this.whitespace;
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            int c;
            log.debug("Starting identifier");
            while ((c = r.read()) != -1) {
                if (Character.isLetterOrDigit((char)c)) {
                    w.write((char)c);
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    w.write(this.whitespace);
                    continue;
                }
                w.write(95);
            }
            log.debug("Finished identifier");
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "IDENTIFIER";
    }
}

