/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.transformers.ByteArrayToCharTransformer;
import org.mmbase.util.transformers.ByteToCharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableTransformer;

public class Hex
extends ByteArrayToCharTransformer
implements ByteToCharTransformer,
ConfigurableTransformer {
    private static final long serialVersionUID = 0L;
    private static final String ENCODING = "HEX";
    private static final int HEX = 1;
    int to = 1;

    @Override
    public void configure(int t) {
        this.to = t;
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put(ENCODING, new Config(Hex.class, 1, "Encoding bytearrays to and from a hexidecimal string"));
        return h;
    }

    @Override
    public String transform(byte[] bytes) {
        StringBuilder strbuf = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            if ((element & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(element & 0xFF, 16));
        }
        return strbuf.toString();
    }

    @Override
    public byte[] transformBack(String r) {
        try {
            int strlen = r.length();
            byte[] retval = new byte[strlen / 2];
            for (int i = 0; i < strlen; i += 2) {
                char c1 = r.charAt(i);
                char c2 = r.charAt(i + 1);
                int b = 0;
                b = c1 >= '0' && c1 <= '9' ? (b += 16 * (c1 - 48)) : (b += 16 * (10 + c1 - 97));
                b = c2 >= '0' && c2 <= '9' ? (b += c2 - 48) : (b += 10 + c2 - 97);
                retval[i / 2] = (byte)b;
            }
            return retval;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("the entered string to decode properly was wrong: " + e);
        }
    }

    @Override
    public String getEncoding() {
        return ENCODING;
    }
}

