/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.BufferedReaderTransformer;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableReaderTransformer;
import org.mmbase.util.transformers.RegexpReplacer;
import org.mmbase.util.transformers.UnknownCodingException;

public abstract class ChunkedTransformer<P>
extends ConfigurableReaderTransformer
implements CharTransformer {
    private static final Logger log = Logging.getLoggerInstance(ChunkedTransformer.class);
    public static final int XMLTEXT_WORDS = 1;
    public static final int XMLTEXT = 2;
    public static final int WORDS = 3;
    public static final int LINES = 4;
    public static final int ENTIRE = 5;
    public static final int ONLY_USE_FIRST_MATCHING_PATTERN = 32;
    public static final int ONLY_REPLACE_FIRST_MATCH = 64;
    protected boolean onlyFirstPattern = false;
    protected boolean onlyFirstMatch = false;

    @Override
    public final void configure(int i) {
        this.onlyFirstMatch = (i & 0x40) > 0;
        this.onlyFirstPattern = (i & 0x20) > 0;
        i &= 0xFFFFFFDF;
        super.configure(i &= 0xFFFFFFBF);
    }

    protected ChunkedTransformer(int i) {
        super(i);
    }

    public ChunkedTransformer() {
        this(3);
    }

    protected Status newStatus() {
        return new Status();
    }

    protected abstract boolean replace(String var1, Writer var2, Status var3) throws IOException;

    protected boolean replaceWord(StringBuilder word, Writer writer, Status status) throws IOException {
        String w;
        int l = word.length();
        StringBuilder postFix = null;
        if (l > 0) {
            postFix = new StringBuilder();
            w = word.toString();
            while (w.endsWith("&quot;")) {
                postFix.insert(0, "&quot;");
                word.setLength(l -= 6);
                w = word.toString();
            }
            if (l > 0) {
                char d = word.charAt(l - 1);
                while (!Character.isLetterOrDigit(d)) {
                    postFix.insert(0, d);
                    word.setLength(--l);
                    if (l == 0) break;
                    d = word.charAt(l - 1);
                }
            }
        }
        w = word.toString();
        while (w.startsWith("&quot;")) {
            writer.write("&quot;");
            word.delete(0, 6);
            l -= 6;
            w = word.toString();
        }
        boolean result = this.replace(w, writer, status);
        if (postFix != null) {
            writer.write(postFix.toString());
        }
        return result;
    }

    protected boolean replace(Status status) {
        return !this.onlyFirstMatch || status.replaced == 0;
    }

    public Writer transformXmlTextWords(Reader r, Writer w) {
        Status status = this.newStatus();
        StringBuilder word = new StringBuilder();
        boolean translating = true;
        try {
            int c;
            log.trace("Starting  replacing");
            while ((c = r.read()) != -1) {
                if (!this.replace(status)) {
                    w.write(c);
                    continue;
                }
                if (c == 60) {
                    translating = false;
                    this.replaceWord(word, w, status);
                    word.setLength(0);
                    w.write(c);
                    continue;
                }
                if (c == 62) {
                    translating = true;
                    w.write(word.toString());
                    w.write(c);
                    String tag = word.toString();
                    status.inA = "a".equals(tag) || tag.startsWith("a ");
                    word.setLength(0);
                    continue;
                }
                if (!translating) {
                    word.append((char)c);
                    continue;
                }
                if (Character.isWhitespace((char)c) || c == 39 || c == 34 || c == 40 || c == 41) {
                    this.replaceWord(word, w, status);
                    word.setLength(0);
                    w.write(c);
                    continue;
                }
                word.append((char)c);
            }
            if (this.replace(status)) {
                if (translating) {
                    this.replaceWord(word, w, status);
                } else {
                    w.write(word.toString());
                }
                word.setLength(0);
            }
            if (log.isDebugEnabled()) {
                log.debug("Finished  replacing. Replaced " + status.replaced + " words");
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    public Writer transformXmlText(Reader r, Writer w) {
        Status status = this.newStatus();
        StringBuilder xmltext = new StringBuilder();
        boolean translating = true;
        try {
            int c;
            log.trace("Starting replacing");
            while ((c = r.read()) != -1) {
                if (!this.replace(status)) {
                    w.write(c);
                    continue;
                }
                if (c == 60) {
                    translating = false;
                    this.replace(xmltext.toString(), w, status);
                    xmltext.setLength(0);
                    w.write(c);
                    continue;
                }
                if (c == 62) {
                    translating = true;
                    xmltext.setLength(0);
                    w.write(c);
                    continue;
                }
                if (!translating) {
                    w.write(c);
                    continue;
                }
                xmltext.append((char)c);
            }
            if (this.replace(status) && translating) {
                this.replace(xmltext.toString(), w, status);
            }
            log.debug("Finished  replacing. Replaced " + status.replaced + " words");
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    public Writer transformWords(Reader r, Writer w) {
        Status status = this.newStatus();
        StringBuilder word = new StringBuilder();
        try {
            int c;
            if (log.isDebugEnabled()) {
                log.trace("Starting replacing words." + Logging.stackTrace());
            }
            while ((c = r.read()) != -1) {
                if (this.replace(status) && (Character.isWhitespace((char)c) || c == 39 || c == 34 || c == 40 || c == 41 || c == 60 || c == 62)) {
                    this.replaceWord(word, w, status);
                    word.setLength(0);
                    w.write(c);
                    continue;
                }
                word.append((char)c);
            }
            if (this.replace(status)) {
                this.replaceWord(word, w, status);
            } else {
                w.write(word.toString());
            }
            log.debug("Finished replacing. Replaced " + status.replaced + " words");
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    public Writer transformLines(Reader r, Writer w) {
        BufferedReader reader = new BufferedReader(r);
        Status status = this.newStatus();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (this.replace(status)) {
                    this.replace(line, w, status);
                } else {
                    w.write(line);
                }
                if ((line = reader.readLine()) == null) continue;
                w.write("\n");
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    public Writer transformEntire(Reader r, Writer w) {
        StringWriter sw = new StringWriter();
        Status status = this.newStatus();
        try {
            BufferedReader br = new BufferedReader(r);
            char[] buf = new char[200];
            int n = br.read(buf, 0, buf.length);
            while (n > 0) {
                sw.write(buf, 0, n);
                n = br.read(buf, 0, buf.length);
            }
            this.replace(sw.toString(), w, status);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return w;
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        switch (this.to) {
            case 1: {
                return this.transformXmlTextWords(r, w);
            }
            case 2: {
                return this.transformXmlText(r, w);
            }
            case 3: {
                return this.transformWords(r, w);
            }
            case 4: {
                return this.transformLines(r, w);
            }
            case 5: {
                return this.transformEntire(r, w);
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    protected abstract String base();

    @Override
    public String getEncoding() {
        switch (this.to) {
            case 1: {
                return this.base() + "_XMLTEXT_WORDS";
            }
            case 2: {
                return this.base() + "_XMLTEXT";
            }
            case 3: {
                return this.base() + "_WORDS";
            }
            case 4: {
                return this.base() + "_LINES";
            }
            case 5: {
                return this.base() + "_ENTIRE";
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put(this.base() + "_XMLTEXT_WORDS", new Config(RegexpReplacer.class, 1, "Search and replaces regexps word-by-word, only in XML text() blocks."));
        h.put(this.base() + "_XMLTEXT", new Config(RegexpReplacer.class, 2, "Search and replaces regexps, only in XML text() blocks."));
        h.put(this.base() + "_WORDS", new Config(RegexpReplacer.class, 3, "Search and replaces regexps word-by-word"));
        h.put(this.base() + "_LINES", new Config(RegexpReplacer.class, 4, "Search and replaces regexps, line-by-line"));
        h.put(this.base() + "_ENTIRE", new Config(RegexpReplacer.class, 5, "Search and replaces regexps"));
        return Collections.unmodifiableMap(h);
    }

    public static void main(String[] argv) {
        ChunkedTransformer trans = new ChunkedTransformer(2){

            @Override
            protected boolean replace(String string, Writer w, Status status) throws IOException {
                w.write(string);
                return false;
            }

            @Override
            protected String base() {
                return "test";
            }
        };
        BufferedReaderTransformer trans2 = new BufferedReaderTransformer(){

            @Override
            protected boolean transform(PrintWriter bw, String line, BufferedReaderTransformer.Status status) {
                bw.println(line);
                return true;
            }

            @Override
            protected BufferedReaderTransformer.Status createNewStatus() {
                return null;
            }
        };
        long startTime = System.currentTimeMillis();
        if (argv.length > 0) {
            if ("buf1".equals(argv[0])) {
                trans.transform(new BufferedReader(new InputStreamReader(System.in)), new BufferedWriter(new OutputStreamWriter(System.out)));
            } else if ("buf2".equals(argv[0])) {
                trans2.transform(new InputStreamReader(System.in), new BufferedWriter(new OutputStreamWriter(System.out)));
            } else {
                System.err.println("Don't understand '" + argv[0] + "'");
            }
        } else {
            trans.transform(new InputStreamReader(System.in), new OutputStreamWriter(System.out));
        }
        long duration = System.currentTimeMillis() - startTime;
        System.err.println("Converstion took " + duration + " ms");
    }

    protected class Status {
        int replaced = 0;
        boolean inA = false;
        final Set<P> used;

        protected Status() {
            this.used = ChunkedTransformer.this.onlyFirstMatch ? new HashSet() : null;
        }
    }
}

