/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.transformers.ByteToCharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableTransformer;

public class Base64
implements ByteToCharTransformer,
ConfigurableTransformer {
    private static final long serialVersionUID = 0L;
    private static final String ENCODING = "BASE64";
    private static final int BASE_64 = 1;
    private static final char[] map1;
    private static final byte[] map2;
    int to = 1;

    @Override
    public void configure(int t) {
        this.to = t;
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put(ENCODING, new Config(Base64.class, 1, "Base 64 encoding base on sun.misc.BASE64* classes"));
        return h;
    }

    @Override
    public String transform(byte[] in) {
        int iLen = in.length;
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iLen ? in[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return new String(out);
    }

    @Override
    public Writer transform(InputStream in, Writer w) {
        int iLen = 0;
        int op = 0;
        while (true) {
            try {
                int ch;
                do {
                    if ((ch = in.read()) != -1) {
                        ++iLen;
                    }
                    int i0 = ch & 0xFF;
                    ch = in.read();
                    if (ch != -1) {
                        ++iLen;
                    }
                    int i1 = ch != -1 ? ch & 0xFF : 0;
                    ch = in.read();
                    if (ch != -1) {
                        ++iLen;
                    }
                    int i2 = ch != -1 ? ch & 0xFF : 0;
                    int o0 = i0 >>> 2;
                    int o1 = (i0 & 3) << 4 | i1 >>> 4;
                    int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
                    int o3 = i2 & 0x3F;
                    int oDataLen = (iLen * 4 + 2) / 3;
                    w.write(map1[o0]);
                    ++op;
                    w.write(map1[o1]);
                    w.write(++op < oDataLen ? map1[o2] : 61);
                    w.write(++op < oDataLen ? map1[o3] : 61);
                    ++op;
                } while (ch != -1);
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        return w;
    }

    @Override
    public byte[] transformBack(String r) {
        char[] in = r.toCharArray();
        int iLen = in.length;
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iLen ? in[ip++] : 65;
            int n = i3 = ip < iLen ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            byte b2 = map2[i2];
            byte b3 = map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    @Override
    public OutputStream transformBack(Reader in, OutputStream out) {
        try {
            int c;
            StringWriter sw = new StringWriter();
            while ((c = in.read()) != -1) {
                sw.write(c);
            }
            out.write(this.transformBack(sw.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    @Override
    public final OutputStream transformBack(Reader r) {
        return this.transformBack(r, new ByteArrayOutputStream());
    }

    @Override
    public final Writer transform(InputStream in) {
        return this.transform(in, new StringWriter());
    }

    @Override
    public String getEncoding() {
        return ENCODING;
    }

    public static void main(String[] argv) throws Exception {
        Base64 enc = new Base64();
        enc.transform(System.in, new OutputStreamWriter((OutputStream)System.out, "UTF-8")).flush();
    }

    static {
        int c;
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        Base64.map1[i++] = 43;
        Base64.map1[i++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            Base64.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64.map2[Base64.map1[i]] = (byte)i;
        }
    }
}

