/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.util.regex.Pattern;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.DiacriticsRemover;
import org.mmbase.util.transformers.StringTransformer;

public class Asciifier
extends StringTransformer {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = Logging.getLoggerInstance(Asciifier.class);
    private static final Pattern NOASCII = Pattern.compile("[^\\p{ASCII}]");
    private static final Pattern NOASCII_MULTIPLE = Pattern.compile("[^\\p{ASCII}]+");
    private String replacer = "?";
    private boolean removeDiacritics = true;
    private boolean collapseMultiple = false;
    private Pattern more;

    public void setReplacer(String r) {
        this.replacer = r;
    }

    public String getReplacer() {
        return this.replacer;
    }

    public void setRemoveDiacritis(boolean b) {
        this.removeDiacritics = b;
    }

    public void setCollapseMultiple(boolean m) {
        this.collapseMultiple = m;
    }

    public void setMoreDisallowed(String more) {
        this.more = Pattern.compile(more);
    }

    @Override
    public String transform(String str) {
        LOG.debug("Starting asciifier");
        if (this.removeDiacritics) {
            str = DiacriticsRemover.INSTANCE.transform(str);
        }
        if (this.more != null) {
            str = this.more.matcher(str).replaceAll("\u00e9");
        }
        str = this.collapseMultiple ? NOASCII_MULTIPLE.matcher(str).replaceAll(this.replacer) : NOASCII.matcher(str).replaceAll(this.replacer);
        return str;
    }

    @Override
    public String toString() {
        return "ASCIIFIER";
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Use at least one argument");
            return;
        }
        Asciifier a = new Asciifier();
        if (argv.length > 1) {
            a.setReplacer(argv[1]);
        }
        System.out.println(a.transform(argv[0]));
    }
}

