/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.mmbase.util.externalprocess.CommandLauncher;
import org.mmbase.util.externalprocess.ProcessException;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.StringTransformer;

public abstract class AbstractCommandStringTransformer
extends StringTransformer {
    private static final Logger log = Logging.getLoggerInstance(AbstractCommandStringTransformer.class);
    private boolean throwErrors = false;

    public void setThrowErrors(boolean te) {
        this.throwErrors = te;
    }

    protected abstract String[] getCommand();

    @Override
    public final String transform(String s) {
        try {
            String encoding = System.getProperty("file.encoding");
            CommandLauncher launcher = new CommandLauncher("Transformer");
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes(encoding));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            launcher.execute(this.getCommand());
            launcher.waitAndWrite(inputStream, outputStream, errorStream);
            return new String(outputStream.toByteArray(), encoding) + new String(errorStream.toByteArray(), encoding);
        }
        catch (UnsupportedEncodingException uee) {
            log.error(uee.toString());
        }
        catch (ProcessException pe) {
            if (this.throwErrors) {
                throw new RuntimeException(pe);
            }
            log.error(pe.toString());
        }
        return s;
    }

    @Override
    public String toString() {
        return this.getCommand()[0].toUpperCase();
    }
}

