/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.magicfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.AbstractDetector;
import org.mmbase.util.xml.ErrorHandler;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlDetector
extends AbstractDetector {
    private static final Logger log = Logging.getLoggerInstance(XmlDetector.class);
    protected String namespace = null;
    protected Pattern publicId = null;

    public void setXmlns(String xmlns) {
        this.namespace = xmlns;
    }

    public void setPublicId(String dt) {
        this.publicId = Pattern.compile(dt);
    }

    @Override
    public boolean test(byte[] lithmus, InputStream input) {
        return this.test(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean test(InputStream input) {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            Handler handler = new Handler();
            parser.setContentHandler(handler);
            parser.setDTDHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(new ErrorHandler(false, 3));
            InputSource source = new InputSource(input);
            parser.parse(source);
            return false;
        }
        catch (Matched m) {
            log.debug("Matched " + m.getMessage());
            return true;
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException ioe) {
            log.warn(ioe);
            return false;
        }
    }

    @Override
    public void configure(Element el) {
        super.configure(el);
        if (this.namespace == null && this.publicId == null) {
            throw new IllegalStateException("Not configured with either namespace or publicId");
        }
    }

    @Override
    public String toString() {
        return "xmlns:" + this.namespace + " publicid:" + this.publicId;
    }

    protected class Handler
    extends DefaultHandler {
        protected Handler() {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            if (uri.equals(XmlDetector.this.namespace)) {
                throw new Matched("Namespace " + uri);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (XmlDetector.this.publicId != null && XmlDetector.this.publicId.matcher(publicId).matches()) {
                throw new Matched("publicId " + publicId);
            }
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    protected class Matched
    extends RuntimeException {
        public Matched(String mes) {
            super(mes);
        }
    }
}

