/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.magicfile;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.BasicDetector;
import org.mmbase.util.magicfile.Detector;
import org.mmbase.util.magicfile.DetectorProvider;
import org.mmbase.util.xml.DocumentReader;
import org.mmbase.util.xml.Instantiator;
import org.mmbase.util.xml.XMLWriter;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MagicXMLReader
extends DocumentReader
implements DetectorProvider {
    private static final Logger log = Logging.getLoggerInstance(MagicXMLReader.class);
    private static DetectorProvider provider;
    protected static final String MAGICXMLFILE = "magic.xml";

    private static void loadDetectorProvider(String config) throws IllegalArgumentException {
        try {
            MagicXMLReader reader;
            InputSource is = ResourceLoader.getConfigurationRoot().getInputSource(config);
            if (is != null && (reader = new MagicXMLReader(is)) != null) {
                DetectorProvider dp;
                log.info("Magic XML file is: " + reader.getSystemId());
                final ArrayList<Detector> detectors = new ArrayList<Detector>(reader.getDetectors());
                provider = dp = new DetectorProvider(){

                    @Override
                    public List<Detector> getDetectors() {
                        return detectors;
                    }
                };
            }
        }
        catch (IOException ie) {
            log.warn(ie);
        }
    }

    public static synchronized DetectorProvider getInstance() {
        if (provider == null) {
            MagicXMLReader.loadDetectorProvider(MAGICXMLFILE);
            ResourceWatcher watcher = new ResourceWatcher(){

                @Override
                public void onChange(String file) {
                    MagicXMLReader.loadDetectorProvider(file);
                }
            };
            watcher.start();
            watcher.add(MAGICXMLFILE);
        }
        return provider;
    }

    private MagicXMLReader(InputSource is) {
        super(is, MagicXMLReader.class);
    }

    public String getVersion() {
        Element e = this.getElementByPath("magic.info.version");
        return MagicXMLReader.getElementValue(e);
    }

    public String getAuthor() {
        Element e = this.getElementByPath("magic.info.author");
        return MagicXMLReader.getElementValue(e);
    }

    public String getDescription() {
        Element e = this.getElementByPath("magic.info.description");
        return MagicXMLReader.getElementValue(e);
    }

    @Override
    public List<Detector> getDetectors() {
        CopyOnWriteArrayList<Detector> detectors = new CopyOnWriteArrayList<Detector>();
        Element e = this.getElementByPath("magic.detectorlist");
        if (e == null) {
            log.fatal("Could not find magic/detectorlist in magic.xml");
            return detectors;
        }
        for (Element element : MagicXMLReader.getChildElements(e)) {
            try {
                Detector d = this.getOneDetector(element);
                detectors.add(d);
            }
            catch (Exception ex) {
                log.error(ex.getClass() + " " + ex.getMessage() + ": " + XMLWriter.write(element));
            }
        }
        return detectors;
    }

    private Detector getOneDetector(Element e) throws SAXException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Detector d = e.getAttribute("class") == null || e.getAttribute("class").equals("") ? new BasicDetector() : (Detector)Instantiator.getInstance(e, new Object[0]);
        d.configure(e);
        Element e1 = MagicXMLReader.getElementByPath(e, "detector.childlist");
        if (e1 != null) {
            for (Element element : MagicXMLReader.getChildElements(e1)) {
                try {
                    Detector child = this.getOneDetector(element);
                    d.addChild(child, 1);
                }
                catch (Exception ex) {
                    log.warn(ex.getClass() + " " + ex.getMessage() + ": " + XMLWriter.write(e1));
                }
            }
        }
        return d;
    }
}

