/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.magicfile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.mmbase.util.SerializableInputStream;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.Detector;
import org.mmbase.util.magicfile.DetectorProvider;
import org.mmbase.util.magicfile.MagicParser;
import org.mmbase.util.magicfile.MagicXMLReader;

public class MagicFile {
    private static final Logger log = Logging.getLoggerInstance(MagicFile.class);
    protected static final int BUFSIZE = 4598;
    public static final String FAILED = "Failed to determine type";
    private static MagicFile instance;
    protected final DetectorProvider detectors;

    public static MagicFile getInstance() {
        if (instance == null) {
            instance = new MagicFile();
        }
        return instance;
    }

    private MagicFile() {
        DetectorProvider d = MagicXMLReader.getInstance();
        if (d == null) {
            d = new MagicParser();
        }
        this.detectors = d;
    }

    public List<Detector> getDetectors() {
        return this.detectors.getDetectors();
    }

    protected String test(String path) {
        try {
            return this.getMimeType(new File(path));
        }
        catch (IOException e) {
            return "File not found " + path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMimeType(File file) throws IOException {
        try (FileInputStream fir = null;){
            String extension;
            String fileName;
            int i;
            fir = new FileInputStream(file);
            String result = this.getMimeType(fir);
            if (result == FAILED && (i = (fileName = file.getName()).lastIndexOf(".")) > 0 && (extension = fileName.substring(i + 1)).length() > 0) {
                result = this.extensionToMimeType(fileName.substring(i + 1));
            }
            String string = result;
            return string;
        }
    }

    protected String getMimeType(byte[] input, InputStream in) throws IOException {
        byte[] lithmus;
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Mark not supported on " + in);
        }
        List<Detector> list = this.getDetectors();
        if (list == null || list.isEmpty()) {
            log.warn("No detectors found");
            return FAILED;
        }
        if (input.length > 4598) {
            lithmus = new byte[4598];
            System.arraycopy(input, 0, lithmus, 0, 4598);
            log.debug("getMimeType was called with big bytearray cutting to 4598 bytes");
        } else {
            lithmus = input;
        }
        for (Detector detector : list) {
            in.reset();
            if (!detector.test(lithmus, in)) continue;
            log.debug("Matched " + detector);
            return detector.getMimeType();
        }
        return FAILED;
    }

    public String getMimeType(byte[] input) {
        try {
            return this.getMimeType(input, new ByteArrayInputStream(input));
        }
        catch (IOException ioe) {
            log.error(ioe);
            return FAILED;
        }
    }

    public String getMimeType(InputStream input) throws IOException {
        byte[] lithmus = new byte[4598];
        if (!input.markSupported()) {
            input = new SerializableInputStream(input, -1L);
        }
        int res = input.read(lithmus, 0, 4598);
        if (log.isDebugEnabled()) {
            log.debug("read " + res + "  bytes from " + input);
        }
        return this.getMimeType(lithmus, input);
    }

    public String extensionToMimeType(String extension) {
        for (Detector detector : this.getDetectors()) {
            for (String ex : detector.getExtensions()) {
                if (!ex.equalsIgnoreCase(extension)) continue;
                return detector.getMimeType();
            }
        }
        return FAILED;
    }

    public String mimeTypeToExtension(String mimeType) {
        for (Detector detector : this.getDetectors()) {
            Iterator<String> iterator;
            if (!mimeType.equalsIgnoreCase(detector.getMimeType()) || !(iterator = detector.getExtensions().iterator()).hasNext()) continue;
            String ex = iterator.next();
            return ex;
        }
        return "";
    }

    public String getMimeType(byte[] data, String extension) {
        String result = this.getMimeType(data);
        if (result.equals(FAILED)) {
            result = this.extensionToMimeType(extension);
        }
        return result;
    }

    public static void main(String[] argv) {
        MagicFile magicFile = MagicFile.getInstance();
        if (argv.length == 1) {
            try {
                log.info(magicFile.getMimeType(new File(argv[0])));
            }
            catch (IOException e) {
                log.info(argv[0] + " cannot be opened or read: " + e.toString());
            }
        } else {
            for (Detector d : magicFile.getDetectors()) {
                log.info(d.toString());
            }
        }
    }
}

