/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.magicfile;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.AbstractDetector;
import org.mmbase.util.magicfile.Detector;
import org.mmbase.util.xml.DocumentReader;
import org.w3c.dom.Element;

public class BasicDetector
extends AbstractDetector {
    private static final Logger log = Logging.getLoggerInstance(BasicDetector.class);
    private static final int BIG_ENDIAN = 0;
    private static final int LITTLE_ENDIAN = 1;
    private static final String[] label = new String[]{"big endian", "little endian"};
    private String rawinput;
    private int offset = -1;
    private String type;
    private String typeAND;
    private String test;
    private char testComparator;
    private String xString;
    private int xInt;
    private char xChar;
    private boolean hasX;

    public void setOffset(String offset) {
        this.offset = Integer.parseInt(offset);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public String getTest() {
        return this.test;
    }

    public void setComparator(char comparator) {
        this.testComparator = comparator;
    }

    public char getComparator() {
        return this.testComparator;
    }

    @Override
    public boolean test(byte[] lithmus, InputStream sin) {
        if (lithmus == null || lithmus.length == 0 || this.offset == -1) {
            return false;
        }
        boolean hit = this.type.equals("string") ? this.testString(lithmus) : (this.type.equals("beshort") ? this.testShort(lithmus, 0) : (this.type.equals("belong") ? this.testLong(lithmus, 0) : (this.type.equals("leshort") ? this.testShort(lithmus, 1) : (this.type.equals("lelong") ? this.testLong(lithmus, 1) : (this.type.equals("byte") ? this.testByte(lithmus) : false)))));
        if (hit) {
            log.debug("Detector " + this + " hit");
            for (Detector child : this.childList) {
                if (!child.test(lithmus, sin)) continue;
                String s = child.getDesignation();
                if (s.startsWith("\\b")) {
                    s = s.substring(2);
                }
                this.message = this.message + " " + s;
            }
        }
        return hit;
    }

    @Override
    public String getDesignation() {
        if (this.hasX) {
            int n = this.message.indexOf("%d");
            if (n >= 0) {
                return this.message.substring(0, n) + this.xInt + this.message.substring(n + 2);
            }
            n = this.message.indexOf("%s");
            if (n >= 0) {
                return this.message.substring(0, n) + this.xString + this.message.substring(n + 2);
            }
            n = this.message.indexOf("%c");
            if (n >= 0) {
                return this.message.substring(0, n) + this.xChar + this.message.substring(n + 2);
            }
        }
        return this.message;
    }

    private int byteArrayToInt(byte[] ar) {
        StringBuilder buf = new StringBuilder();
        for (byte element : ar) {
            buf.append(Integer.toHexString(element & 0xFF));
        }
        return Integer.decode("0x" + buf.toString());
    }

    private long byteArrayToLong(byte[] ar) {
        StringBuilder buf = new StringBuilder();
        for (byte element : ar) {
            buf.append(Integer.toHexString(element & 0xFF));
        }
        return Long.decode("0x" + buf.toString());
    }

    protected boolean testString(byte[] lithmus) {
        if (this.test.length() == 0) {
            log.warn("TEST STRING LENGTH ZERO FOR [" + this.rawinput + "]");
            return false;
        }
        int maxNeeded = this.offset + this.test.length();
        if (maxNeeded > lithmus.length) {
            return false;
        }
        try {
            this.xString = new String(lithmus, this.offset, this.test.length(), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        log.debug("test string = '" + this.test + "' (" + this.message + ") comparing with '" + this.xString + "'");
        int n = this.xString.compareTo(this.test);
        switch (this.testComparator) {
            case '=': {
                return n == 0;
            }
            case '>': {
                this.hasX = true;
                return n > 0;
            }
            case '<': {
                this.hasX = true;
                return n < 0;
            }
        }
        return false;
    }

    protected boolean testShort(byte[] lithmus, int endian) {
        if (lithmus.length < this.offset + 1) {
            return false;
        }
        log.debug("testing " + label[endian] + " short for " + this.rawinput);
        int found = 0;
        if (endian == 0) {
            found = this.byteArrayToInt(new byte[]{lithmus[this.offset], lithmus[this.offset + 1]});
        } else if (endian == 1) {
            found = this.byteArrayToInt(new byte[]{lithmus[this.offset + 1], lithmus[this.offset]});
        }
        this.xInt = found;
        if (this.test.equals("x")) {
            this.hasX = true;
            return true;
        }
        if (this.test.equals("")) {
            return false;
        }
        int v = Integer.decode(this.test);
        log.debug("dumb string conversion: 0x" + Integer.toHexString(lithmus[this.offset] & 0xFF) + Integer.toHexString(lithmus[this.offset + 1] & 0xFF));
        switch (this.testComparator) {
            case '=': {
                log.debug(Integer.toHexString(v) + " = " + Integer.toHexString(found));
                return v == found;
            }
            case '>': {
                this.hasX = true;
                return found > v;
            }
            case '<': {
                this.hasX = true;
                return found < v;
            }
        }
        return false;
    }

    protected boolean testLong(byte[] lithmus, int endian) {
        if (lithmus.length < 4) {
            return false;
        }
        log.debug("testing " + label[endian] + " long for " + this.rawinput);
        long found = 0L;
        try {
            if (endian == 0) {
                found = this.byteArrayToLong(new byte[]{lithmus[this.offset], lithmus[this.offset + 1], lithmus[this.offset + 2], lithmus[this.offset + 3]});
            } else if (endian == 1) {
                found = this.byteArrayToLong(new byte[]{lithmus[this.offset + 3], lithmus[this.offset + 2], lithmus[this.offset + 1], lithmus[this.offset]});
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (!this.message.equals("")) {
                log.error("Failed to test " + label[endian] + " long for " + this.message);
            } else {
                log.error("Failed to test " + label[endian] + " long:");
            }
            log.error("Offset out of bounds: " + this.offset + " while max is ");
            return false;
        }
        this.xInt = (int)found;
        if (this.test.equals("x")) {
            this.hasX = true;
            return true;
        }
        if (this.test.equals("")) {
            return false;
        }
        long v = Long.decode(this.test);
        switch (this.testComparator) {
            case '=': {
                log.debug("checking " + label[endian] + " long: " + Long.toHexString(v) + " = " + Long.toHexString(found));
                return v == found;
            }
            case '>': {
                this.hasX = true;
                return found > v;
            }
            case '<': {
                this.hasX = true;
                return found < v;
            }
        }
        return false;
    }

    protected boolean testByte(byte[] lithmus) {
        log.debug("testing byte for " + this.rawinput);
        if (this.test.equals("x")) {
            this.hasX = true;
            this.xInt = lithmus[this.offset];
            this.xChar = (char)lithmus[this.offset];
            this.xString = "" + this.xChar;
            return true;
        }
        if (this.test.equals("")) {
            return false;
        }
        byte b = (byte)Integer.decode(this.test).intValue();
        switch (this.testComparator) {
            case '=': {
                return b == lithmus[this.offset];
            }
            case '&': {
                byte filter = (byte)(lithmus[this.offset] & b);
                return filter == b;
            }
        }
        return false;
    }

    public String getRawInput() {
        return this.rawinput;
    }

    protected String xmlEntities(String s) {
        StringBuilder res = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    res.append("&gt;");
                    continue block5;
                }
                case '<': {
                    res.append("&lt;");
                    continue block5;
                }
                case '&': {
                    res.append("&amp;");
                    continue block5;
                }
                default: {
                    char n = c;
                    if (n == '\t' || n == '\n' || n == '\r' || n >= ' ' && n < '\u0080') {
                        res.append(c);
                        continue block5;
                    }
                    String oct = Integer.toOctalString(n);
                    res.append("\\");
                    for (int j = 3; j > oct.length(); --j) {
                        res.append("0");
                    }
                    res.append(oct);
                }
            }
        }
        return res.toString();
    }

    public void toXML(FileWriter f) throws IOException {
        this.toXML(f, 0);
    }

    public void toXML(FileWriter f, int level) throws IOException {
        char[] pad;
        StringBuilder s = new StringBuilder();
        if (level > 0) {
            pad = new char[level * 4];
            for (int i = 0; i < level * 4; ++i) {
                pad[i] = 32;
            }
        } else {
            pad = new char[]{};
        }
        String padStr = new String(pad);
        String comparatorEntity = this.testComparator == '>' ? "&gt;" : (this.testComparator == '<' ? "&lt;" : (this.testComparator == '&' ? "&amp;" : "" + this.testComparator));
        s.append(padStr + "<detector>\n" + padStr + "  <mimetype>" + this.getMimeType() + "</mimetype>\n" + padStr + "  <extension>" + this.getExtension() + "</extension>\n" + padStr + "  <designation>" + this.xmlEntities(this.message) + "</designation>\n" + padStr + "  <test offset=\"" + this.offset + "\" type=\"" + this.type + "\" comparator=\"" + comparatorEntity + "\">" + this.xmlEntities(this.test) + "</test>\n");
        f.write(s.toString());
        if (this.childList.size() > 0) {
            f.write(padStr + "  <childlist>\n");
            for (Detector detector : this.childList) {
                if (detector instanceof BasicDetector) {
                    ((BasicDetector)detector).toXML(f, level + 1);
                    continue;
                }
                log.warn("" + detector);
            }
            f.write(padStr + "  </childlist>\n");
        }
        f.write(padStr + "</detector>\n");
    }

    private String convertOctals(String s) {
        int p = 0;
        int stoppedAt = 0;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            while (p < s.length()) {
                char c = s.charAt(p);
                if (c == '\\') {
                    if (p > s.length() - 4) break;
                    boolean failed = false;
                    for (int p0 = p + 1; p0 < p + 4; ++p0) {
                        char c0 = s.charAt(p0);
                        if (c0 >= '0' && c0 <= '7') continue;
                        failed = true;
                    }
                    if (!failed) {
                        byte[] bytes = s.substring(stoppedAt, p).getBytes("US-ASCII");
                        buf.write(bytes, 0, bytes.length);
                        buf.write(Integer.parseInt(s.substring(p + 1, p + 4), 8));
                        stoppedAt = p + 4;
                        p += 4;
                        continue;
                    }
                    ++p;
                    continue;
                }
                ++p;
            }
            byte[] bytes = s.substring(stoppedAt, p).getBytes("US-ASCII");
            buf.write(bytes, 0, bytes.length);
            return buf.toString("US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            return "";
        }
    }

    @Override
    public void configure(Element e) {
        super.configure(e);
        Element e1 = DocumentReader.getElementByPath(e, "detector.test");
        if (e1 != null) {
            this.setTest(this.convertOctals(DocumentReader.getElementValue(e1)));
            this.setOffset(e1.getAttribute("offset"));
            this.setType(e1.getAttribute("type"));
            String comparator = e1.getAttribute("comparator");
            if (comparator.equals("&gt;")) {
                this.setComparator('>');
            } else if (comparator.equals("&lt;")) {
                this.setComparator('<');
            } else if (comparator.equals("&amp;")) {
                this.setComparator('&');
            } else if (comparator.length() == 1) {
                this.setComparator(comparator.charAt(0));
            } else {
                this.setComparator('=');
            }
        }
    }

    @Override
    public String toString() {
        if (!this.valid) {
            return "parse error";
        }
        StringBuilder res = new StringBuilder("[" + this.offset + "] {" + this.type);
        if (this.typeAND != null) {
            res.append("[" + this.typeAND + "]");
        }
        res.append("} " + this.testComparator + "(" + this.test + ") " + this.message);
        if (this.childList.size() > 0) {
            res.append("\n");
            for (Detector aChildList : this.childList) {
                res.append("> ").append(aChildList.toString());
            }
        }
        return res.toString();
    }
}

