/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.magicfile;

import java.util.ArrayList;
import java.util.List;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.BasicDetector;
import org.mmbase.util.magicfile.Detector;
import org.mmbase.util.xml.DocumentReader;
import org.mmbase.util.xml.XMLWriter;
import org.w3c.dom.Element;

public abstract class AbstractDetector
implements Detector {
    private static final Logger log = Logging.getLoggerInstance(BasicDetector.class);
    protected String message = "Unknown";
    private final List<String> extensions = new ArrayList<String>();
    private String mimetype = "application/octet-stream";
    protected final List<Detector> childList = new ArrayList<Detector>();
    protected boolean valid = true;

    @Override
    public void addChild(Detector detector, int level) {
        if (level == 1) {
            this.childList.add(detector);
        } else if (level > 1) {
            if (this.childList.size() == 0) {
                log.debug("Hm. level = " + level + ", but childList is empty");
            } else {
                this.childList.get(this.childList.size() - 1).addChild(detector, level - 1);
            }
        }
    }

    @Override
    public void setExtension(String extension) {
        this.extensions.add(0, extension);
    }

    @Override
    public String getExtension() {
        if (this.extensions.size() == 0) {
            return "";
        }
        return this.extensions.get(0);
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public void setMimeType(String mimetype) {
        this.mimetype = mimetype;
    }

    @Override
    public String getMimeType() {
        if ("???".equals(this.mimetype)) {
            return "application/octet-stream";
        }
        return this.mimetype;
    }

    public void setDesignation(String designation) {
        this.message = designation;
    }

    @Override
    public String getDesignation() {
        return this.message;
    }

    @Override
    public void setValid(boolean v) {
        this.valid = v;
    }

    @Override
    public boolean valid() {
        return this.valid;
    }

    @Override
    public void configure(Element e) {
        Element e1 = DocumentReader.getElementByPath(e, "detector.mimetype");
        if (e1 == null) {
            log.error("No mime type in " + XMLWriter.write(e));
        }
        this.setMimeType(DocumentReader.getElementValue(e1));
        e1 = DocumentReader.getElementByPath(e, "detector.extension");
        this.setExtension(DocumentReader.getElementValue(e1));
        e1 = DocumentReader.getElementByPath(e, "detector.designation");
        this.setDesignation(DocumentReader.getElementValue(e1));
    }

    public String toString() {
        return this.getClass() + " " + this.getMimeType() + " " + this.extensions;
    }
}

