/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.mmbase.core.event.EventManager;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.logging.MDC;
import org.mmbase.util.logging.log4j.Log4jLevel;
import org.mmbase.util.logging.log4j.LoggerRepository;

public final class Log4jImpl
extends org.apache.log4j.Logger
implements Logger {
    private static final org.apache.log4j.spi.LoggerRepository log4jRepository = new LoggerRepository(Log4jImpl.getRootLogger());
    private static Logger log = Logging.getLoggerInstance(Log4jImpl.class);
    private static final String classname = Log4jImpl.class.getName();
    private static PrintStream stderr;

    protected Log4jImpl(String name) {
        super(name);
    }

    public static Log4jImpl getLoggerInstance(String name) {
        try {
            return (Log4jImpl)log4jRepository.getLogger(name);
        }
        catch (ClassCastException e) {
            Log4jImpl root = (Log4jImpl)Log4jImpl.getRootLogger();
            root.error("ClassCastException, probably you've forgotten a class attribute in your configuration file. It must say class=\"" + Log4jImpl.class.getName() + "\"");
            return root;
        }
    }

    public static MDC getMDC() {
        return new MDC(){

            @Override
            public void put(String key, Object value) {
                if (value != null) {
                    org.apache.log4j.MDC.put((String)key, (Object)value);
                } else {
                    org.apache.log4j.MDC.remove((String)key);
                }
            }

            @Override
            public Object get(String key) {
                return org.apache.log4j.MDC.get((String)key);
            }
        };
    }

    public static void configure(String s) {
        if (s != null && s.length() > 0) {
            log.info("logging configurationfile : " + s);
            ResourceLoader rl = Logging.getResourceLoader();
            log.info("using " + rl + " for resolving " + s + " -> " + rl.getResource(s));
            ResourceWatcher configWatcher = new ResourceWatcher(rl){

                @Override
                public void onChange(String s) {
                    Log4jImpl.doConfigure(this.resourceLoader.getResourceAsStream(s));
                }
            };
            configWatcher.clear();
            configWatcher.add(s);
            Log4jImpl.doConfigure(rl.getResourceAsStream(s));
            configWatcher.setDelay(10000L);
            configWatcher.start();
            log = Log4jImpl.getLoggerInstance(Log4jImpl.class.getName());
            Log4jImpl err = Log4jImpl.getLoggerInstance("STDERR");
            if (err.getLevel() != Log4jLevel.FATAL) {
                log.service("Redirecting stderr to MMBase logging (If you don't like this, then put the STDER logger to 'fatal')");
                if (stderr == null) {
                    stderr = System.err;
                }
                System.setErr(new LoggerStream(err));
            }
        } else {
            log.debug("Not configuring log4j, because no configuration file given");
        }
    }

    protected static void doConfigure(InputStream i) {
        DOMConfigurator domConfigurator = new DOMConfigurator();
        domConfigurator.doConfigure(i, log4jRepository);
    }

    protected static void doConfigure(File f) {
        log.info("Parsing " + f.getAbsolutePath());
        try {
            Log4jImpl.doConfigure(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            log.error("Could not find " + f + " to configure logging: " + e.toString());
        }
    }

    @Override
    public void setLevel(Level p) {
        switch (p.toInt()) {
            case 5000: {
                this.setLevel(Log4jLevel.TRACE);
                break;
            }
            case 10000: {
                this.setLevel(Log4jLevel.DEBUG);
                break;
            }
            case 15000: {
                this.setLevel(Log4jLevel.SERVICE);
                break;
            }
            case 20000: {
                this.setLevel(Log4jLevel.INFO);
                break;
            }
            case 30000: {
                this.setLevel(Log4jLevel.WARN);
                break;
            }
            case 40000: {
                this.setLevel(Log4jLevel.ERROR);
                break;
            }
            case 50000: {
                this.setLevel(Log4jLevel.FATAL);
                break;
            }
            case 0x7FFFFFFF: {
                this.setLevel(Log4jLevel.OFF);
                break;
            }
        }
    }

    public static Category getInstance(String name) {
        return Log4jImpl.getLogger(name);
    }

    public static org.apache.log4j.Logger getLogger(String name) {
        return log4jRepository.getLogger(name);
    }

    @Override
    public void trace(Object message) {
        if (log4jRepository.isDisabled(5000)) {
            return;
        }
        if (Log4jLevel.TRACE.isGreaterOrEqual((Priority)this.getEffectiveLevel())) {
            this.forcedLog(classname, (Priority)Log4jLevel.TRACE, message, null);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (log4jRepository.isDisabled(5000)) {
            return;
        }
        if (Log4jLevel.TRACE.isGreaterOrEqual((Priority)this.getEffectiveLevel())) {
            this.forcedLog(classname, (Priority)Log4jLevel.TRACE, message, t);
        }
    }

    @Override
    public void service(Object message) {
        if (log4jRepository.isDisabled(15000)) {
            return;
        }
        if (Log4jLevel.SERVICE.isGreaterOrEqual((Priority)this.getEffectiveLevel())) {
            this.forcedLog(classname, (Priority)Log4jLevel.SERVICE, message, null);
        }
    }

    @Override
    public void service(Object message, Throwable t) {
        if (log4jRepository.isDisabled(15000)) {
            return;
        }
        if (Log4jLevel.SERVICE.isGreaterOrEqual((Priority)this.getEffectiveLevel())) {
            this.forcedLog(classname, (Priority)Log4jLevel.SERVICE, message, t);
        }
    }

    @Override
    public boolean isServiceEnabled() {
        if (log4jRepository.isDisabled(15000)) {
            return false;
        }
        return Log4jLevel.SERVICE.isGreaterOrEqual((Priority)this.getEffectiveLevel());
    }

    @Override
    public boolean isTraceEnabled() {
        if (log4jRepository.isDisabled(5000)) {
            return false;
        }
        return Log4jLevel.TRACE.isGreaterOrEqual((Priority)this.getEffectiveLevel());
    }

    @Override
    public boolean isEnabledFor(Level l) {
        return !log4jRepository.isDisabled(l.toInt());
    }

    public static void shutdown() {
        Log4jImpl err = Log4jImpl.getLoggerInstance("STDERR");
        if (err.getLevel() != Log4jLevel.FATAL) {
            if (stderr != null) {
                log.service("System stderr now going to stdout");
                System.setErr(System.out);
            } else {
                log.service("System stderr now going to stderr");
                System.setErr(stderr);
            }
        }
        log4jRepository.shutdown();
    }

    static {
        EventManager.getInstance().addEventListener(new SystemEventListener(){

            @Override
            public void notify(SystemEvent se) {
                if (se instanceof SystemEvent.Shutdown) {
                    log.info("Shutting down log4j");
                    log4jRepository.shutdown();
                }
            }

            @Override
            public int getWeight() {
                return Integer.MAX_VALUE;
            }
        });
    }

    private static class LoggerStream
    extends PrintStream {
        private final Logger log;
        private int checkCount = 0;

        LoggerStream(Log4jImpl l) throws IllegalArgumentException {
            super(System.out);
            if (l == null) {
                throw new IllegalArgumentException("logger == null");
            }
            this.log = l;
        }

        private LoggerStream() {
            super(System.out);
            this.log = null;
        }

        @Override
        public void print(char[] s) {
            this.log.warn(new String(s));
        }

        @Override
        public void print(String s) {
            this.log.warn(s);
        }

        @Override
        public void print(Object s) {
            this.log.warn(s.toString());
        }

        @Override
        public void println(char[] s) {
            this.log.warn(new String(s));
        }

        @Override
        public void println(String s) {
            if (this.checkCount > 0) {
                System.out.println(s);
            } else {
                ++this.checkCount;
                this.log.trace("6");
                this.log.warn(s);
                --this.checkCount;
            }
        }

        @Override
        public void println(Object s) {
            if (Exception.class.isAssignableFrom(s.getClass())) {
                this.log.fatal(s.toString());
            } else {
                this.log.warn(s.toString());
            }
        }
    }
}

