/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging.java;

import java.io.IOException;
import java.util.logging.LogManager;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public final class Impl
implements Logger {
    private static final Logger log = Logging.getLoggerInstance(Impl.class);
    private final java.util.logging.Logger logger;

    protected Impl(String name) {
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    public Impl(java.util.logging.Logger l) {
        this.logger = l;
    }

    public static Impl getLoggerInstance(String name) {
        return new Impl(name);
    }

    public static void configure(String s) {
        if ("".equals(s)) {
            System.out.println("Using default java logging configuration");
        } else {
            try {
                log.info("logging configurationfile : " + s);
                ResourceLoader rl = Logging.getResourceLoader();
                log.info("using " + rl + " for resolving " + s);
                ResourceWatcher configWatcher = new ResourceWatcher(rl){

                    @Override
                    public void onChange(String s) {
                        try {
                            log.info("Reading configuration file : " + s);
                            LogManager.getLogManager().readConfiguration(this.resourceLoader.getResourceAsStream(s));
                        }
                        catch (IOException ioe) {
                            log.error(ioe);
                        }
                    }
                };
                configWatcher.add(s);
                configWatcher.start();
                LogManager.getLogManager().readConfiguration(rl.getResourceAsStream(s));
            }
            catch (IOException ioe) {
                log.error(ioe);
            }
        }
    }

    protected java.util.logging.Level getJavaLevel(Level p) {
        switch (p.toInt()) {
            case 5000: {
                return java.util.logging.Level.FINER;
            }
            case 10000: {
                return java.util.logging.Level.FINE;
            }
            case 15000: {
                return java.util.logging.Level.CONFIG;
            }
            case 20000: {
                return java.util.logging.Level.INFO;
            }
            case 30000: {
                return java.util.logging.Level.WARNING;
            }
            case 40000: {
                return java.util.logging.Level.SEVERE;
            }
            case 50000: {
                return java.util.logging.Level.SEVERE;
            }
        }
        return java.util.logging.Level.FINE;
    }

    @Override
    public void setLevel(Level p) {
        this.logger.setLevel(this.getJavaLevel(p));
    }

    @Override
    public void trace(Object m) {
        this.logger.log(java.util.logging.Level.FINER, "{0}", m);
    }

    @Override
    public void trace(Object m, Throwable t) {
        this.logger.log(java.util.logging.Level.FINER, "" + m, t);
    }

    @Override
    public void debug(Object m) {
        this.logger.log(java.util.logging.Level.FINE, "{0}", m);
    }

    @Override
    public void debug(Object m, Throwable t) {
        this.logger.log(java.util.logging.Level.FINE, "" + m, t);
    }

    @Override
    public void service(Object m) {
        this.logger.log(java.util.logging.Level.CONFIG, "{0}", m);
    }

    @Override
    public void service(Object m, Throwable t) {
        this.logger.log(java.util.logging.Level.CONFIG, "" + m, t);
    }

    @Override
    public void info(Object m) {
        this.logger.log(java.util.logging.Level.INFO, "{0}", m);
    }

    @Override
    public void info(Object m, Throwable t) {
        this.logger.log(java.util.logging.Level.INFO, "" + m, t);
    }

    @Override
    public void warn(Object m) {
        this.logger.log(java.util.logging.Level.WARNING, "{0}", m);
    }

    @Override
    public void warn(Object m, Throwable t) {
        this.logger.log(java.util.logging.Level.WARNING, "" + m, t);
    }

    @Override
    public void error(Object m) {
        this.logger.log(java.util.logging.Level.SEVERE, "{0}", m);
    }

    @Override
    public void error(Object m, Throwable t) {
        this.logger.log(java.util.logging.Level.SEVERE, "" + m, t);
    }

    @Override
    public void fatal(Object m) {
        this.logger.log(java.util.logging.Level.SEVERE, "{0}", m);
    }

    @Override
    public void fatal(Object m, Throwable t) {
        this.logger.log(java.util.logging.Level.SEVERE, "" + m, t);
    }

    private java.util.logging.Level getLevel() {
        java.util.logging.Level level = null;
        java.util.logging.Logger l = this.logger;
        while (level == null) {
            level = l.getLevel();
            l = l.getParent();
        }
        return level;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLevel().intValue() <= java.util.logging.Level.FINER.intValue();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLevel().intValue() <= java.util.logging.Level.FINE.intValue();
    }

    @Override
    public boolean isServiceEnabled() {
        return this.getLevel().intValue() <= java.util.logging.Level.CONFIG.intValue();
    }

    @Override
    public boolean isEnabledFor(Level l) {
        return this.getLevel().intValue() <= this.getJavaLevel(l).intValue();
    }
}

