/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.io.PrintStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.mmbase.util.logging.AbstractSimpleImpl;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;

public class SimpleImpl
extends AbstractSimpleImpl
implements Logger {
    private static SimpleImpl root = new SimpleImpl("");
    private static PrintStream ps = System.out;
    private static Map<String, SimpleImpl> loggers = new ConcurrentHashMap<String, SimpleImpl>();
    private final String name;

    public static SimpleImpl getLoggerInstance(String name) {
        SimpleImpl impl = loggers.get(name);
        if (impl == null) {
            impl = new SimpleImpl(name);
            impl.level = SimpleImpl.root.level;
            loggers.put(name, impl);
        }
        return impl;
    }

    private SimpleImpl(String n) {
        this.name = n;
    }

    public static void configure(String c) {
        if (c == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(c, ",");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if ("stderr".equals(token)) {
                ps = System.err;
            }
            if ("stdout".equals(token)) {
                ps = System.out;
                continue;
            }
            if ("trace".equals(token)) {
                root.setLevel(Level.TRACE);
                continue;
            }
            if ("debug".equals(token)) {
                root.setLevel(Level.DEBUG);
                continue;
            }
            if ("service".equals(token)) {
                root.setLevel(Level.SERVICE);
                continue;
            }
            if ("info".equals(token)) {
                root.setLevel(Level.INFO);
                continue;
            }
            if ("warn".equals(token)) {
                root.setLevel(Level.WARN);
                continue;
            }
            if ("error".equals(token)) {
                root.setLevel(Level.ERROR);
                continue;
            }
            if (!"fatal".equals(token)) continue;
            root.setLevel(Level.FATAL);
        }
    }

    @Override
    protected final void log(String s) {
        ps.println(this.name + ":" + s);
    }
}

