/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import org.apache.log4j.Category;
import org.apache.log4j.xml.DOMConfigurator;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class Performance {
    static final double SECOND = 1000.0;
    static int repeats = 1000;
    static boolean isdebugenabled = false;
    static boolean nosystem = false;
    static boolean log4j = false;
    static String description = null;
    static boolean delay = false;
    static int delaytime = 10;
    static int burstLen = 3;
    static int warmingup = 200;

    static double doCaseLog4j(String s) {
        int i;
        DOMConfigurator.configure((String)s);
        Category cat = Category.getInstance((String)"A0123456789.B0123456789.C0123456789");
        for (i = 0; i < warmingup; ++i) {
            cat.info((Object)"warming up.");
        }
        long before = System.currentTimeMillis();
        for (i = 0; i < repeats; ++i) {
            cat.info((Object)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
        }
        long after = System.currentTimeMillis();
        return 1000.0 * (double)(after - before) / (double)repeats;
    }

    static double doCaseNoSystem() {
        int i;
        for (i = 0; i < warmingup; ++i) {
            System.err.println("warming up.");
        }
        long before = System.currentTimeMillis();
        for (i = 0; i < repeats; ++i) {
            System.err.println("INFO abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
        }
        long after = System.currentTimeMillis();
        return 1000.0 * (double)(after - before) / (double)repeats;
    }

    static double doCase(Logger log) {
        int i;
        if (delay) {
            return Performance.doCaseDelayed(log);
        }
        for (i = 0; i < warmingup; ++i) {
            log.info("warming up.");
        }
        long before = System.currentTimeMillis();
        for (i = 0; i < repeats; ++i) {
            log.info("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
        }
        long after = System.currentTimeMillis();
        return 1000.0 * (double)(after - before) / (double)repeats;
    }

    static double doCaseDelayed(Logger log) {
        int j = 0;
        try {
            int i;
            for (i = 0; i < warmingup; ++i) {
                log.info("warming up.");
                if (++j != burstLen) continue;
                j = 0;
                Thread.sleep(delaytime);
            }
            long before = System.currentTimeMillis();
            for (i = 0; i < repeats; ++i) {
                log.info("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
                if (++j != burstLen) continue;
                j = 0;
                Thread.sleep(delaytime);
            }
            long after = System.currentTimeMillis();
            j = 0;
            Thread.sleep(3000L);
            long before_ref = System.currentTimeMillis();
            for (i = 0; i < repeats; ++i) {
                log.trace("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
                if (j++ != burstLen) continue;
                j = 0;
                Thread.sleep(delaytime);
            }
            long after_ref = System.currentTimeMillis();
            return 1000.0 * (double)(after - before - (after_ref - before_ref)) / (double)repeats;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    static double doCaseIfDebug(Logger log) {
        int i;
        for (i = 0; i < warmingup; ++i) {
            if (!log.isDebugEnabled()) continue;
            log.debug("warming up.");
        }
        long before = System.currentTimeMillis();
        for (i = 0; i < repeats; ++i) {
            if (!log.isDebugEnabled()) continue;
            log.debug("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
        }
        long after = System.currentTimeMillis();
        return 1000.0 * (double)(after - before) / (double)repeats;
    }

    static double Case(String configuration) {
        if (log4j) {
            return Performance.doCaseLog4j(configuration);
        }
        if (nosystem) {
            return Performance.doCaseNoSystem();
        }
        Logging.configure(ResourceLoader.getConfigurationRoot(), configuration);
        Logger log = Logging.getLoggerInstance("A0123456789.B0123456789.C0123456789");
        if (isdebugenabled) {
            return Performance.doCaseIfDebug(log);
        }
        return Performance.doCase(log);
    }

    static void printCase(String configuration) {
        String s = (description == null ? "" : description) + " (" + configuration + ") : ";
        for (int i = s.length(); i < 50; ++i) {
            s = s + " ";
        }
        System.out.print(s);
        double benchmark = Performance.Case(configuration);
        System.out.println(benchmark + " us/logging");
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].substring(1).equals("repeats")) {
                    repeats = Integer.valueOf(args[++i]);
                }
                if (args[i].substring(1).equals("isdebugenabled")) {
                    boolean bl = isdebugenabled = !isdebugenabled;
                }
                if (args[i].substring(1).equals("nosystem")) {
                    boolean bl = nosystem = !nosystem;
                }
                if (args[i].substring(1).equals("log4j")) {
                    boolean bl = log4j = !log4j;
                }
                if (args[i].substring(1).equals("desc")) {
                    description = args[++i];
                }
                if (args[i].substring(1).equals("delay")) {
                    boolean bl = delay = !delay;
                }
                if (args[i].substring(1).equals("delaytime")) {
                    delaytime = Integer.valueOf(args[++i]);
                }
                if (!args[i].substring(1).equals("burstlen")) continue;
                burstLen = Integer.valueOf(args[++i]);
                continue;
            }
            warmingup = repeats / 10;
            Performance.printCase(args[i]);
        }
        Logging.shutdown();
    }
}

