/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.SimpleImpl;

public class LoggerWrapper
implements Logger {
    private static final Set<LoggerWrapper> wrappers = new HashSet<LoggerWrapper>();
    private Logger log;
    private final String name;

    static Set<LoggerWrapper> getWrappers() {
        return Collections.unmodifiableSet(wrappers);
    }

    LoggerWrapper(Logger log, String name) {
        this.name = name;
        this.setLogger(log);
        wrappers.add(this);
    }

    String getName() {
        return this.name;
    }

    final Logger setLogger(Logger log) {
        if (log == null) {
            log = this.log == null ? SimpleImpl.getLoggerInstance(this.name) : this.log;
            System.err.println("Tried to instantiate logger wrapper with null!");
            log.error("Tried to instantiate logger wrapper with null!", new Exception());
        }
        Logger org = this.log;
        this.log = log;
        return org;
    }

    @Override
    public final void trace(Object m) {
        if (this.log != null) {
            this.log.trace(m);
        }
    }

    @Override
    public final void trace(Object m, Throwable t) {
        if (this.log != null) {
            this.log.trace(m, t);
        }
    }

    @Override
    public final void debug(Object m) {
        if (this.log != null) {
            this.log.debug(m);
        }
    }

    @Override
    public final void debug(Object m, Throwable t) {
        if (this.log != null) {
            this.log.debug(m, t);
        }
    }

    @Override
    public final void service(Object m) {
        this.log.service(m);
    }

    @Override
    public final void service(Object m, Throwable t) {
        this.log.service(m, t);
    }

    @Override
    public final void info(Object m) {
        this.log.info(m);
    }

    @Override
    public final void info(Object m, Throwable t) {
        this.log.info(m, t);
    }

    @Override
    public final void warn(Object m) {
        this.log.warn(m);
    }

    @Override
    public final void warn(Object m, Throwable t) {
        this.log.warn(m, t);
    }

    @Override
    public final void error(Object m) {
        this.log.error(m);
    }

    @Override
    public final void error(Object m, Throwable t) {
        this.log.error(m, t);
    }

    @Override
    public final void fatal(Object m) {
        this.log.fatal(m);
    }

    @Override
    public final void fatal(Object m, Throwable t) {
        this.log.fatal(m, t);
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public final boolean isServiceEnabled() {
        return this.log.isServiceEnabled();
    }

    @Override
    public final void setLevel(Level p) {
        this.log.setLevel(p);
    }

    @Override
    public final boolean isEnabledFor(Level l) {
        return this.log.isEnabledFor(l);
    }

    public String toString() {
        return "LoggerWrapper[" + this.log + "]";
    }
}

